/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dashboard;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dashboard.Dashboard;
import com.vaadin.flow.component.dashboard.DashboardSection;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.dom.Element;

@Tag(value="vaadin-dashboard-widget")
@JsModule(value="@vaadin/dashboard/src/vaadin-dashboard-widget.js")
@NpmPackage(value="@vaadin/dashboard", version="25.1.0-alpha1")
public class DashboardWidget
extends Component {
    private int colspan = 1;
    private int rowspan = 1;

    public DashboardWidget() {
        this(null, null);
    }

    public DashboardWidget(String title) {
        this(title, null);
    }

    public DashboardWidget(Component content) {
        this(null, content);
    }

    public DashboardWidget(String title, Component content) {
        if (title != null) {
            this.setTitle(title);
        }
        if (content != null) {
            this.setContent(content);
        }
    }

    public String getTitle() {
        return this.getElement().getProperty("widgetTitle");
    }

    public void setTitle(String title) {
        this.getElement().setProperty("widgetTitle", title == null ? "" : title);
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int colspan) {
        if (colspan < 1) {
            throw new IllegalArgumentException("Cannot set a colspan lower than 1.");
        }
        if (this.colspan == colspan) {
            return;
        }
        this.colspan = colspan;
        this.notifyParentDashboardOrSection();
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public void setRowspan(int rowspan) {
        if (rowspan < 1) {
            throw new IllegalArgumentException("Cannot set a rowspan lower than 1.");
        }
        if (this.rowspan == rowspan) {
            return;
        }
        this.rowspan = rowspan;
        this.notifyParentDashboardOrSection();
    }

    public Component getContent() {
        return this.getChildren().filter(component -> !component.getElement().hasAttribute("slot")).findAny().orElse(null);
    }

    public void setContent(Component content) {
        Component initialContent = this.getContent();
        if (initialContent == content) {
            return;
        }
        if (initialContent != null) {
            this.getElement().removeChild(new Element[]{initialContent.getElement()});
        }
        if (content != null) {
            this.getElement().appendChild(new Element[]{content.getElement()});
        }
    }

    public Component getHeaderContent() {
        return SlotUtils.getChildInSlot((HasElement)this, (String)"header-content");
    }

    public void setHeaderContent(Component header) {
        SlotUtils.setSlot((HasElement)this, (String)"header-content", (Component[])new Component[]{header});
    }

    public void setVisible(boolean visible) {
        throw new UnsupportedOperationException("Dashboard widget does not support setting visibility");
    }

    public boolean isVisible() {
        return true;
    }

    private void notifyParentDashboardOrSection() {
        this.getParent().ifPresent(parent -> {
            if (parent instanceof Dashboard) {
                Dashboard dashboard = (Dashboard)parent;
                dashboard.updateClient();
            } else if (parent instanceof DashboardSection) {
                DashboardSection section = (DashboardSection)parent;
                section.updateClient();
            }
        });
    }
}

