/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dashboard;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementDetachEvent;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.shared.Registration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class DashboardChildDetachHandler
implements ElementDetachListener {
    private final Component component;
    private final Map<Element, Registration> childDetachListenerMap = new HashMap<Element, Registration>();

    DashboardChildDetachHandler(Component component) {
        this.component = component;
    }

    public void onDetach(ElementDetachEvent e) {
        Element detachedElement = e.getSource();
        boolean childDetachedFromContainer = this.component.getElement().getChildren().noneMatch(containerChild -> Objects.equals(detachedElement, containerChild));
        if (childDetachedFromContainer) {
            this.childDetachListenerMap.get(detachedElement).remove();
            this.childDetachListenerMap.remove(detachedElement);
            detachedElement.getComponent().ifPresent(this::removeChild);
        }
    }

    void refreshListeners() {
        this.component.getChildren().forEach(child -> {
            Element childElement = child.getElement();
            if (!this.childDetachListenerMap.containsKey(childElement)) {
                this.childDetachListenerMap.put(childElement, childElement.addDetachListener((ElementDetachListener)this));
            }
        });
    }

    abstract void removeChild(Component var1);
}

