/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dashboard;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dashboard.DashboardChildDetachHandler;
import com.vaadin.flow.component.dashboard.DashboardItemMoveModeChangedEvent;
import com.vaadin.flow.component.dashboard.DashboardItemMovedEvent;
import com.vaadin.flow.component.dashboard.DashboardItemRemovedEvent;
import com.vaadin.flow.component.dashboard.DashboardItemResizeModeChangedEvent;
import com.vaadin.flow.component.dashboard.DashboardItemResizedEvent;
import com.vaadin.flow.component.dashboard.DashboardItemSelectedChangedEvent;
import com.vaadin.flow.component.dashboard.DashboardSection;
import com.vaadin.flow.component.dashboard.DashboardVariant;
import com.vaadin.flow.component.dashboard.DashboardWidget;
import com.vaadin.flow.component.dashboard.HasWidgets;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

@Tag(value="vaadin-dashboard")
@JsModule.Container(value={@JsModule(value="@vaadin/dashboard/src/vaadin-dashboard.js"), @JsModule(value="./flow-component-renderer.js")})
@NpmPackage(value="@vaadin/dashboard", version="25.0.0-alpha19")
public class Dashboard
extends Component
implements HasWidgets,
HasSize,
HasThemeVariant<DashboardVariant> {
    private static final ThreadLocal<Boolean> suppressClientUpdates = ThreadLocal.withInitial(() -> false);
    private final List<Component> childrenComponents = new ArrayList<Component>();
    private final DashboardChildDetachHandler childDetachHandler = this.getChildDetachHandler();
    private DashboardI18n i18n;
    private boolean pendingUpdate = false;

    public Dashboard() {
        this.initItemMovedClientEventListener();
        this.initItemResizedClientEventListener();
        this.initItemRemovedClientEventListener();
    }

    public DashboardSection addSection() {
        return this.addSection((String)null);
    }

    public DashboardSection addSection(String title) {
        DashboardSection dashboardSection = new DashboardSection(title);
        this.addSection(dashboardSection);
        return dashboardSection;
    }

    public void addSection(DashboardSection section) {
        this.doAddSection(section);
        this.updateClient();
    }

    @Override
    public List<DashboardWidget> getWidgets() {
        ArrayList widgets = new ArrayList();
        this.childrenComponents.forEach(component -> {
            if (component instanceof DashboardSection) {
                DashboardSection section = (DashboardSection)component;
                widgets.addAll(section.getWidgets());
            } else {
                widgets.add((DashboardWidget)((Object)component));
            }
        });
        return Collections.unmodifiableList(widgets);
    }

    @Override
    public void add(Collection<DashboardWidget> widgets) {
        Objects.requireNonNull(widgets, "Widgets to add cannot be null.");
        widgets.forEach(widget -> Objects.requireNonNull(widget, "Widget to add cannot be null."));
        widgets.forEach(this::doAddWidget);
        this.updateClient();
    }

    @Override
    public void addWidgetAtIndex(int index, DashboardWidget widget) {
        Objects.requireNonNull(widget, "Widget to add cannot be null.");
        if (index < 0) {
            throw new IllegalArgumentException("Cannot add a widget with a negative index.");
        }
        if (index > this.childrenComponents.size()) {
            throw new IllegalArgumentException(String.format("Cannot add a widget with index %d when there are %d children components", index, this.childrenComponents.size()));
        }
        this.doAddWidgetAtIndex(index, widget);
        this.updateClient();
    }

    @Override
    public void remove(Collection<DashboardWidget> widgets) {
        Objects.requireNonNull(widgets, "Widgets to remove cannot be null.");
        ArrayList<DashboardWidget> toRemove = new ArrayList<DashboardWidget>(widgets.size());
        for (DashboardWidget widget : widgets) {
            Objects.requireNonNull(widget, "Widget to remove cannot be null.");
            Element parent = widget.getElement().getParent();
            if (parent == null) {
                LoggerFactory.getLogger(this.getClass()).debug("Removal of a widget with no parent does nothing.");
                continue;
            }
            if (this.getElement().equals((Object)parent)) {
                toRemove.add(widget);
                continue;
            }
            throw new IllegalArgumentException("The given widget (" + widget + ") is not a child of this dashboard");
        }
        if (!toRemove.isEmpty()) {
            toRemove.forEach(this::doRemoveItem);
            this.updateClient();
        }
    }

    public void remove(DashboardSection section) {
        Objects.requireNonNull(section, "Section to remove cannot be null.");
        this.doRemoveItem(section);
        this.updateClient();
    }

    @Override
    public void removeAll() {
        if (this.getChildren().findAny().isEmpty()) {
            return;
        }
        this.doRemoveAll();
        this.updateClient();
    }

    public Integer getMaximumColumnCount() {
        String maxColCount = this.getStyle().get("--vaadin-dashboard-col-max-count");
        return maxColCount == null ? null : Integer.valueOf(maxColCount);
    }

    public void setMaximumColumnCount(Integer maxColCount) {
        this.getStyle().set("--vaadin-dashboard-col-max-count", maxColCount == null ? null : String.valueOf(maxColCount));
    }

    public String getMinimumColumnWidth() {
        return this.getStyle().get("--vaadin-dashboard-col-min-width");
    }

    public void setMinimumColumnWidth(String minColWidth) {
        this.getStyle().set("--vaadin-dashboard-col-min-width", minColWidth);
    }

    public String getMaximumColumnWidth() {
        return this.getStyle().get("--vaadin-dashboard-col-max-width");
    }

    public void setMaximumColumnWidth(String maxColWidth) {
        this.getStyle().set("--vaadin-dashboard-col-max-width", maxColWidth);
    }

    public String getMinimumRowHeight() {
        return this.getStyle().get("--vaadin-dashboard-row-min-height");
    }

    public void setMinimumRowHeight(String minRowHeight) {
        this.getStyle().set("--vaadin-dashboard-row-min-height", minRowHeight);
    }

    public String getGap() {
        return this.getStyle().get("--vaadin-dashboard-gap");
    }

    public void setGap(String gap) {
        this.getStyle().set("--vaadin-dashboard-gap", gap);
    }

    public String getPadding() {
        return this.getStyle().get("--vaadin-dashboard-padding");
    }

    public void setPadding(String padding) {
        this.getStyle().set("--vaadin-dashboard-padding", padding);
    }

    public void setEditable(boolean editable) {
        this.getElement().setProperty("editable", editable);
    }

    public boolean isEditable() {
        return this.getElement().getProperty("editable", false);
    }

    public void setDenseLayout(boolean dense) {
        this.getElement().setProperty("denseLayout", dense);
    }

    public boolean isDenseLayout() {
        return this.getElement().getProperty("denseLayout", false);
    }

    public Registration addItemMovedListener(ComponentEventListener<DashboardItemMovedEvent> listener) {
        return this.addListener(DashboardItemMovedEvent.class, listener);
    }

    public Registration addItemResizedListener(ComponentEventListener<DashboardItemResizedEvent> listener) {
        return this.addListener(DashboardItemResizedEvent.class, listener);
    }

    public Registration addItemRemovedListener(ComponentEventListener<DashboardItemRemovedEvent> listener) {
        return this.addListener(DashboardItemRemovedEvent.class, listener);
    }

    public Registration addItemSelectedChangedListener(ComponentEventListener<DashboardItemSelectedChangedEvent> listener) {
        return this.addListener(DashboardItemSelectedChangedEvent.class, listener);
    }

    public Registration addItemMoveModeChangedListener(ComponentEventListener<DashboardItemMoveModeChangedEvent> listener) {
        return this.addListener(DashboardItemMoveModeChangedEvent.class, listener);
    }

    public Registration addItemResizeModeChangedListener(ComponentEventListener<DashboardItemResizeModeChangedEvent> listener) {
        return this.addListener(DashboardItemResizeModeChangedEvent.class, listener);
    }

    public DashboardI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(DashboardI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
            if (i18n.equals(this.i18n)) {
                this.setI18nWithJS();
            }
        }));
    }

    public Stream<Component> getChildren() {
        return this.childrenComponents.stream();
    }

    public void setVisible(boolean visible) {
        throw new UnsupportedOperationException("Dashboard does not support setting visibility");
    }

    public boolean isVisible() {
        return true;
    }

    public void setRootHeadingLevel(Integer rootHeadingLevel) {
        if (rootHeadingLevel == null) {
            this.getElement().removeProperty("rootHeadingLevel");
        } else {
            this.getElement().setProperty("rootHeadingLevel", (double)rootHeadingLevel.intValue());
        }
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.getElement().executeJs("Vaadin.FlowComponentHost.patchVirtualContainer(this);", new Serializable[0]);
        this.customizeItemMovedEvent();
        this.doUpdateClient();
    }

    Component getItem(int nodeId) {
        return this.getChildren().map(item -> {
            if (nodeId == item.getElement().getNode().getId()) {
                return item;
            }
            if (item instanceof DashboardSection) {
                DashboardSection section = (DashboardSection)item;
                return section.getWidgets().stream().filter(sectionItem -> nodeId == sectionItem.getElement().getNode().getId()).findAny().orElse(null);
            }
            return null;
        }).filter(Objects::nonNull).findAny().orElseThrow();
    }

    private void withoutClientUpdate(Runnable action) {
        suppressClientUpdates.set(true);
        try {
            action.run();
        }
        finally {
            suppressClientUpdates.remove();
        }
    }

    void updateClient() {
        if (suppressClientUpdates.get().booleanValue() || this.pendingUpdate) {
            return;
        }
        this.pendingUpdate = true;
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> {
            this.doUpdateClient();
            this.pendingUpdate = false;
        }));
    }

    private void doUpdateClient() {
        this.childDetachHandler.refreshListeners();
        this.updateClientItems();
    }

    private void updateClientItems() {
        AtomicInteger itemIndex = new AtomicInteger();
        ArrayList<String> itemRepresentations = new ArrayList<String>();
        ArrayList<Component> flatOrderedComponents = new ArrayList<Component>();
        for (Component component : this.childrenComponents) {
            String itemRepresentation;
            flatOrderedComponents.add(component);
            if (component instanceof DashboardSection) {
                DashboardSection section = (DashboardSection)component;
                flatOrderedComponents.addAll(section.getWidgets());
                List<DashboardWidget> sectionWidgets = section.getWidgets();
                int sectionIndex = itemIndex.getAndIncrement();
                String sectionWidgetsRepresentation = sectionWidgets.stream().map(widget -> Dashboard.getWidgetRepresentation(widget, itemIndex.getAndIncrement())).collect(Collectors.joining(","));
                itemRepresentation = "{ component: $%d, items: [ %s ], id: %d }".formatted(sectionIndex, sectionWidgetsRepresentation, section.getElement().getNode().getId());
            } else {
                itemRepresentation = Dashboard.getWidgetRepresentation((DashboardWidget)component, itemIndex.getAndIncrement());
            }
            itemRepresentations.add(itemRepresentation);
        }
        String updateItemsSnippet = "this.items = [ %s ];".formatted(String.join((CharSequence)",", itemRepresentations));
        this.getElement().executeJs(updateItemsSnippet, (Serializable[])flatOrderedComponents.toArray(Component[]::new));
    }

    private void setI18nWithJS() {
        ObjectNode i18nJson = JacksonUtils.beanToJson((Object)this.i18n);
        this.getElement().executeJs("this.i18n = Object.assign({}, this.i18n, $0);", new Serializable[]{i18nJson});
    }

    private static String getWidgetRepresentation(DashboardWidget widget, int itemIndex) {
        return "{ component: $%d, colspan: %d, rowspan: %d, id: %d  }".formatted(itemIndex, widget.getColspan(), widget.getRowspan(), widget.getElement().getNode().getId());
    }

    private void doRemoveAll() {
        new ArrayList<Component>(this.childrenComponents).forEach(this::doRemoveItem);
    }

    private void doRemoveItem(Component item) {
        this.getElement().removeChild(new Element[]{item.getElement()});
        this.childrenComponents.remove(item);
    }

    private void doAddWidgetAtIndex(int index, DashboardWidget widget) {
        this.getElement().appendChild(new Element[]{widget.getElement()});
        this.childrenComponents.add(index, widget);
    }

    private void doAddWidget(DashboardWidget widget) {
        this.getElement().appendChild(new Element[]{widget.getElement()});
        this.childrenComponents.add(widget);
    }

    private void doAddSection(DashboardSection section) {
        this.getElement().appendChild(new Element[]{section.getElement()});
        this.childrenComponents.add(section);
    }

    private DashboardChildDetachHandler getChildDetachHandler() {
        return new DashboardChildDetachHandler(this){

            @Override
            void removeChild(Component child) {
                Dashboard.this.childrenComponents.remove(child);
                Dashboard.this.updateClient();
            }
        };
    }

    private void initItemMovedClientEventListener() {
        String itemKey = "event.detail.item";
        String itemsKey = "event.detail.items";
        String sectionKey = "event.detail.section";
        this.getElement().addEventListener("dashboard-item-moved-flow", (DomEventListener & Serializable)e -> {
            if (!this.isEditable()) {
                return;
            }
            this.handleItemMovedClientEvent(e, itemKey, itemsKey, sectionKey);
        }).addEventData(itemKey).addEventData(itemsKey).addEventData(sectionKey);
    }

    private void handleItemMovedClientEvent(DomEvent e, String itemKey, String itemsKey, String sectionKey) {
        List<Component> reorderedItems;
        int itemNodeId = e.getEventData().get(itemKey).intValue();
        ArrayNode itemsNodeIds = (ArrayNode)e.getEventData().get(itemsKey);
        Integer sectionNodeId = e.getEventData().has(sectionKey) ? Integer.valueOf(e.getEventData().get(sectionKey).intValue()) : null;
        DashboardSection section = null;
        if (sectionNodeId == null) {
            reorderedItems = Dashboard.getReorderedItemsList(itemsNodeIds, this);
            this.childrenComponents.clear();
            this.childrenComponents.addAll(reorderedItems);
        } else {
            section = this.getChildren().filter(child -> sectionNodeId.equals(child.getElement().getNode().getId())).map(DashboardSection.class::cast).findAny().orElseThrow();
            reorderedItems = Dashboard.getReorderedItemsList(Dashboard.getSectionItems(itemsNodeIds, sectionNodeId), section);
            section.reorderWidgets(reorderedItems.stream().map(DashboardWidget.class::cast).toList());
        }
        Component movedItem = reorderedItems.stream().filter(item -> itemNodeId == item.getElement().getNode().getId()).findAny().orElseThrow();
        this.fireEvent(new DashboardItemMovedEvent(this, true, movedItem, this.getChildren().toList(), section));
    }

    private void initItemResizedClientEventListener() {
        String idKey = "event.detail.item.id";
        String colspanKey = "event.detail.item.colspan";
        String rowspanKey = "event.detail.item.rowspan";
        this.getElement().addEventListener("dashboard-item-resized", (DomEventListener & Serializable)e -> {
            if (!this.isEditable()) {
                return;
            }
            this.handleItemResizedClientEvent(e, idKey, colspanKey, rowspanKey);
        }).addEventData(idKey).addEventData(colspanKey).addEventData(rowspanKey);
    }

    private void handleItemResizedClientEvent(DomEvent e, String idKey, String colspanKey, String rowspanKey) {
        int nodeId = e.getEventData().get(idKey).intValue();
        int colspan = e.getEventData().get(colspanKey).intValue();
        int rowspan = e.getEventData().get(rowspanKey).intValue();
        DashboardWidget resizedWidget = this.getWidgets().stream().filter(child -> nodeId == child.getElement().getNode().getId()).findAny().orElseThrow();
        this.withoutClientUpdate(() -> {
            resizedWidget.setColspan(colspan);
            resizedWidget.setRowspan(rowspan);
        });
        this.fireEvent(new DashboardItemResizedEvent(this, true, resizedWidget, this.getChildren().toList()));
    }

    private void initItemRemovedClientEventListener() {
        String idKey = "event.detail.item.id";
        this.getElement().addEventListener("dashboard-item-removed", (DomEventListener & Serializable)e -> {
            if (!this.isEditable()) {
                return;
            }
            this.handleItemRemovedClientEvent(e, idKey);
        }).addEventData(idKey);
    }

    private void handleItemRemovedClientEvent(DomEvent e, String idKey) {
        int nodeId = e.getEventData().get(idKey).intValue();
        Component removedItem = this.getItem(nodeId);
        this.withoutClientUpdate(() -> ((Component)removedItem).removeFromParent());
        this.fireEvent(new DashboardItemRemovedEvent(this, true, removedItem, this.getChildren().toList()));
    }

    private void customizeItemMovedEvent() {
        this.getElement().executeJs("this.addEventListener('dashboard-item-moved', (e) => {\n  function mapItems(items) {\n    return items.map(({id, items}) => ({\n      id,\n      ...(items && { items: mapItems(items) })\n    }));\n  }\n  const flowItemMovedEvent = new CustomEvent('dashboard-item-moved-flow', {\n    detail: {\n      item: e.detail.item.id,\n      items: mapItems(e.detail.items),\n      section: e.detail.section?.id\n    }\n  });\n  this.dispatchEvent(flowItemMovedEvent);\n});", new Serializable[0]);
    }

    private static List<Component> getReorderedItemsList(ArrayNode reorderedItemsFromClient, Component reorderedItemsParent) {
        Objects.requireNonNull(reorderedItemsFromClient);
        Map nodeIdToItems = reorderedItemsParent.getChildren().collect(Collectors.toMap(item -> item.getElement().getNode().getId(), Function.identity()));
        ArrayList<Component> items = new ArrayList<Component>();
        for (int index = 0; index < reorderedItemsFromClient.size(); ++index) {
            int nodeIdFromClient = reorderedItemsFromClient.get(index).get("id").intValue();
            items.add((Component)nodeIdToItems.get(nodeIdFromClient));
        }
        return items;
    }

    private static ArrayNode getSectionItems(ArrayNode items, int sectionNodeId) {
        for (int rootLevelIdx = 0; rootLevelIdx < items.size(); ++rootLevelIdx) {
            JsonNode item = items.get(rootLevelIdx);
            int itemNodeId = item.get("id").intValue();
            if (sectionNodeId != itemNodeId) continue;
            JsonNode sectionObj = items.get(rootLevelIdx);
            return (ArrayNode)sectionObj.get("items");
        }
        return null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class DashboardI18n
    implements Serializable {
        private String selectSection;
        private String selectWidget;
        private String remove;
        private String resize;
        private String resizeApply;
        private String resizeShrinkWidth;
        private String resizeGrowWidth;
        private String resizeShrinkHeight;
        private String resizeGrowHeight;
        private String move;
        private String moveApply;
        private String moveForward;
        private String moveBackward;

        public String getSelectSection() {
            return this.selectSection;
        }

        public DashboardI18n setSelectSection(String selectSection) {
            this.selectSection = selectSection;
            return this;
        }

        public String getSelectWidget() {
            return this.selectWidget;
        }

        public DashboardI18n setSelectWidget(String selectWidget) {
            this.selectWidget = selectWidget;
            return this;
        }

        public String getRemove() {
            return this.remove;
        }

        public DashboardI18n setRemove(String remove) {
            this.remove = remove;
            return this;
        }

        public String getResize() {
            return this.resize;
        }

        public DashboardI18n setResize(String resize) {
            this.resize = resize;
            return this;
        }

        public String getResizeApply() {
            return this.resizeApply;
        }

        public DashboardI18n setResizeApply(String resizeApply) {
            this.resizeApply = resizeApply;
            return this;
        }

        public String getResizeShrinkWidth() {
            return this.resizeShrinkWidth;
        }

        public DashboardI18n setResizeShrinkWidth(String resizeShrinkWidth) {
            this.resizeShrinkWidth = resizeShrinkWidth;
            return this;
        }

        public String getResizeGrowWidth() {
            return this.resizeGrowWidth;
        }

        public DashboardI18n setResizeGrowWidth(String resizeGrowWidth) {
            this.resizeGrowWidth = resizeGrowWidth;
            return this;
        }

        public String getResizeShrinkHeight() {
            return this.resizeShrinkHeight;
        }

        public DashboardI18n setResizeShrinkHeight(String resizeShrinkHeight) {
            this.resizeShrinkHeight = resizeShrinkHeight;
            return this;
        }

        public String getResizeGrowHeight() {
            return this.resizeGrowHeight;
        }

        public DashboardI18n setResizeGrowHeight(String resizeGrowHeight) {
            this.resizeGrowHeight = resizeGrowHeight;
            return this;
        }

        public String getMove() {
            return this.move;
        }

        public DashboardI18n setMove(String move) {
            this.move = move;
            return this;
        }

        public String getMoveApply() {
            return this.moveApply;
        }

        public DashboardI18n setMoveApply(String moveApply) {
            this.moveApply = moveApply;
            return this;
        }

        public String getMoveForward() {
            return this.moveForward;
        }

        public DashboardI18n setMoveForward(String moveForward) {
            this.moveForward = moveForward;
            return this;
        }

        public String getMoveBackward() {
            return this.moveBackward;
        }

        public DashboardI18n setMoveBackward(String moveBackward) {
            this.moveBackward = moveBackward;
            return this;
        }
    }
}

