/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.cookieconsent.testbench;

import com.vaadin.flow.component.cookieconsent.CookieConsent;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.Optional;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

@Element(value="vaadin-cookie-consent")
public class CookieConsentElement
extends TestBenchElement {
    public WebElement getDismissLinkElement() {
        return this.getElementFromContainer(By.className((String)"cc-dismiss"));
    }

    public WebElement getLearnMoreLinkElement() {
        return this.getElementFromContainer(By.className((String)"cc-link"));
    }

    public String getMessage() {
        return this.getAttribute("message");
    }

    public String getDismissLabel() {
        return this.getAttribute("dismiss");
    }

    public String getLearnMoreLabel() {
        return this.getAttribute("learnMore");
    }

    public String getLearnMoreLink() {
        return this.getAttribute("learnMoreLink");
    }

    public String getCookieName() {
        return this.getAttribute("cookieName");
    }

    public CookieConsent.Position getPosition() {
        return Optional.ofNullable(this.getAttribute("position")).map(value -> value.replace('-', '_')).map(String::toUpperCase).map(CookieConsent.Position::valueOf).orElse(null);
    }

    public WebElement getContainer() {
        return this.getDriver().findElement(By.className((String)"cc-window"));
    }

    public SearchContext getContext() {
        return this.getContainer();
    }

    public boolean isDisplayed() {
        return this.getContainer().isDisplayed();
    }

    WebElement getElementFromContainer(By by) {
        WebElement container = this.getContainer();
        return container != null ? container.findElement(by) : null;
    }

    public static final class DefaultValues {
        public static final String MESSAGE = "This website uses cookies to ensure you get the best experience.";
        public static final String DISMISS_LABEL = "Got it!";
        public static final String LEARN_MORE_LABEL = "Learn more";
        public static final String LEARN_MORE_LINK = "https://cookiesandyou.com/";
        public static final CookieConsent.Position POSITION = CookieConsent.Position.TOP;

        private DefaultValues() {
        }
    }
}

