/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.confirmdialog;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.shared.internal.OverlayAutoAddController;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Optional;

@Tag(value="vaadin-confirm-dialog")
@NpmPackage(value="@vaadin/confirm-dialog", version="25.0.0-alpha16")
@JsModule(value="@vaadin/confirm-dialog/src/vaadin-confirm-dialog.js")
public class ConfirmDialog
extends Component
implements HasComponents,
HasSize,
HasStyle {
    public String getWidth() {
        return this.getElement().getProperty("width");
    }

    public void setWidth(String width) {
        this.getElement().setProperty("width", width);
    }

    public String getHeight() {
        return this.getElement().getProperty("height");
    }

    public void setHeight(String height) {
        this.getElement().setProperty("height", height);
    }

    public Style getStyle() {
        throw new UnsupportedOperationException("ConfirmDialog does not support adding styles");
    }

    public void setAriaDescribedBy(String describedBy) {
        this.getElement().setProperty("accessibleDescriptionRef", describedBy);
    }

    public Optional<String> getAriaDescribedBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleDescriptionRef"));
    }

    public ConfirmDialog() {
        new OverlayAutoAddController((Component)this, (SerializableSupplier & Serializable)() -> true);
        this.getElement().addEventListener("opened-changed", (DomEventListener & Serializable)event -> this.close()).setFilter("event.detail.value === false");
    }

    public ConfirmDialog(String header, String text, String confirmText, ComponentEventListener<ConfirmEvent> confirmListener) {
        this();
        this.setHeader(header);
        this.setText(text);
        this.setConfirmButton(confirmText, confirmListener);
    }

    public ConfirmDialog(String header, String text, String confirmText, ComponentEventListener<ConfirmEvent> confirmListener, String cancelText, ComponentEventListener<CancelEvent> cancelListener) {
        this(header, text, confirmText, confirmListener);
        this.setCancelButton(cancelText, cancelListener);
    }

    public ConfirmDialog(String header, String text, String confirmText, ComponentEventListener<ConfirmEvent> confirmListener, String rejectText, ComponentEventListener<RejectEvent> rejectListener, String cancelText, ComponentEventListener<CancelEvent> cancelListener) {
        this(header, text, confirmText, confirmListener, cancelText, cancelListener);
        this.setRejectButton(rejectText, rejectListener);
    }

    public void setCancelable(boolean cancelable) {
        this.getElement().setProperty("cancelButtonVisible", cancelable);
    }

    public void setRejectable(boolean rejectable) {
        this.getElement().setProperty("rejectButtonVisible", rejectable);
    }

    public void setRejectButton(String buttonText, ComponentEventListener<RejectEvent> rejectListener) {
        this.setRejectable(true);
        this.setRejectText(buttonText);
        this.addRejectListener(rejectListener);
    }

    public void setRejectButton(String buttonText, ComponentEventListener<RejectEvent> rejectListener, String theme) {
        this.setRejectButton(buttonText, rejectListener);
        this.setRejectButtonTheme(theme);
    }

    public void setRejectButton(Component component) {
        SlotUtils.setSlot((HasElement)this, (String)"reject-button", (Component[])new Component[]{component});
    }

    public void setCancelButton(String buttonText, ComponentEventListener<CancelEvent> cancelListener) {
        this.setCancelable(true);
        this.setCancelText(buttonText);
        this.addCancelListener(cancelListener);
    }

    public void setCancelButton(String buttonText, ComponentEventListener<CancelEvent> cancelListener, String theme) {
        this.setCancelButton(buttonText, cancelListener);
        this.setCancelButtonTheme(theme);
    }

    public void setCancelButton(Component component) {
        SlotUtils.setSlot((HasElement)this, (String)"cancel-button", (Component[])new Component[]{component});
    }

    public void setConfirmButton(String buttonText, ComponentEventListener<ConfirmEvent> confirmListener) {
        this.setConfirmText(buttonText);
        this.addConfirmListener(confirmListener);
    }

    public void setConfirmButton(String buttonText, ComponentEventListener<ConfirmEvent> confirmListener, String theme) {
        this.setConfirmButton(buttonText, confirmListener);
        this.setConfirmButtonTheme(theme);
    }

    public void setConfirmButton(Component component) {
        SlotUtils.setSlot((HasElement)this, (String)"confirm-button", (Component[])new Component[]{component});
    }

    public void setText(String message) {
        this.getElement().setProperty("message", message);
    }

    public void setText(Component component) {
        this.getElement().appendChild(new Element[]{component.getElement()});
    }

    public void setConfirmText(String confirmText) {
        this.getElement().setProperty("confirmText", confirmText);
    }

    public void setConfirmButtonTheme(String confirmTheme) {
        this.getElement().setProperty("confirmTheme", confirmTheme);
    }

    public Registration addConfirmListener(ComponentEventListener<ConfirmEvent> listener) {
        return ComponentUtil.addListener((Component)this, ConfirmEvent.class, listener);
    }

    public void setCancelText(String cancelText) {
        this.getElement().setProperty("cancelText", cancelText);
    }

    public void setCancelButtonTheme(String cancelTheme) {
        this.getElement().setProperty("cancelTheme", cancelTheme);
    }

    public Registration addCancelListener(ComponentEventListener<CancelEvent> listener) {
        return ComponentUtil.addListener((Component)this, CancelEvent.class, listener);
    }

    public void setRejectText(String rejectText) {
        this.getElement().setProperty("rejectText", rejectText);
    }

    public void setRejectButtonTheme(String rejectTheme) {
        this.getElement().setProperty("rejectTheme", rejectTheme);
    }

    public Registration addRejectListener(ComponentEventListener<RejectEvent> listener) {
        return ComponentUtil.addListener((Component)this, RejectEvent.class, listener);
    }

    public Registration addClosedListener(ComponentEventListener<ClosedEvent> listener) {
        return ComponentUtil.addListener((Component)this, ClosedEvent.class, listener);
    }

    public void setHeader(String header) {
        this.getElement().setProperty("header", header);
    }

    public void setHeader(Component component) {
        SlotUtils.setSlot((HasElement)this, (String)"header", (Component[])new Component[]{component});
    }

    public void open() {
        this.setOpened(true);
    }

    public void close() {
        this.setOpened(false);
    }

    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setOpened(boolean opened) {
        this.setModality(opened);
        this.getElement().setProperty("opened", opened);
    }

    public boolean isCloseOnEsc() {
        return !this.getElement().getProperty("noCloseOnEsc", false);
    }

    public void setCloseOnEsc(boolean closeOnEsc) {
        this.getElement().setProperty("noCloseOnEsc", !closeOnEsc);
    }

    public void removeAll() {
        this.getElement().getChildren().forEach(child -> {
            if (!child.hasAttribute("slot")) {
                child.removeFromParent();
            }
        });
    }

    private void setModality(boolean modal) {
        if (this.isAttached()) {
            this.getUI().ifPresent(ui -> ui.setChildComponentModal((Component)this, modal));
        }
    }

    @DomEvent(value="confirm")
    public static class ConfirmEvent
    extends ComponentEvent<ConfirmDialog> {
        public ConfirmEvent(ConfirmDialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    @DomEvent(value="cancel")
    public static class CancelEvent
    extends ComponentEvent<ConfirmDialog> {
        public CancelEvent(ConfirmDialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    @DomEvent(value="reject")
    public static class RejectEvent
    extends ComponentEvent<ConfirmDialog> {
        public RejectEvent(ConfirmDialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    @DomEvent(value="closed")
    public static class ClosedEvent
    extends ComponentEvent<ConfirmDialog> {
        public ClosedEvent(ConfirmDialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

