/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.ui;

import java.io.Serializable;

import com.vaadin.ui.Component;
import com.vaadin.v7.data.Container;

/**
 * Factory interface for creating new Field-instances based on Container
 * (datasource), item id, property id and uiContext (the component responsible
 * for displaying fields). Currently this interface is used by {@link Table},
 * but might later be used by some other components for {@link Field}
 * generation.
 *
 * <p>
 *
 * @author Vaadin Ltd.
 * @since 6.0
 * @see FormFieldFactory
 *
 * @deprecated As of 8.0, Table is replaced by {@link com.vaadin.ui.Grid}
 */
@Deprecated
public interface TableFieldFactory extends Serializable {
    /**
     * Creates a field based on the Container, item id, property id and the
     * component responsible for displaying the field (most commonly
     * {@link Table}).
     *
     * @param container
     *            the Container where the property belongs to.
     * @param itemId
     *            the item Id.
     * @param propertyId
     *            the Id of the property.
     * @param uiContext
     *            the component where the field is presented.
     * @return A field suitable for editing the specified data or null if the
     *         property should not be editable.
     */
    Field<?> createField(Container container, Object itemId, Object propertyId,
            Component uiContext);

}
