/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.data.util;

import java.util.Collection;

import com.vaadin.v7.data.Container.Hierarchical;

/**
 * A wrapper class for adding external ordering to containers not implementing
 * the {@link com.vaadin.v7.data.Container.Ordered Container.Ordered}
 * interface while retaining {@link Hierarchical} features.
 *
 * @see ContainerOrderedWrapper
 *
 * @deprecated No direct replacement - use an appropriate implementation of
 *             {@code HierarchicalDataProvider} such as {@code TreeDataProvider}
 *             or {@code AbstractBackEndHierarchicalDataProvider}.
 */
@Deprecated
@SuppressWarnings({ "serial" })
public class HierarchicalContainerOrderedWrapper extends ContainerOrderedWrapper
        implements Hierarchical {

    private Hierarchical hierarchical;

    public HierarchicalContainerOrderedWrapper(Hierarchical toBeWrapped) {
        super(toBeWrapped);
        hierarchical = toBeWrapped;
    }

    @Override
    public boolean areChildrenAllowed(Object itemId) {
        return hierarchical.areChildrenAllowed(itemId);
    }

    @Override
    public Collection<?> getChildren(Object itemId) {
        return hierarchical.getChildren(itemId);
    }

    @Override
    public Object getParent(Object itemId) {
        return hierarchical.getParent(itemId);
    }

    @Override
    public boolean hasChildren(Object itemId) {
        return hierarchical.hasChildren(itemId);
    }

    @Override
    public boolean isRoot(Object itemId) {
        return hierarchical.isRoot(itemId);
    }

    @Override
    public Collection<?> rootItemIds() {
        return hierarchical.rootItemIds();
    }

    @Override
    public boolean setChildrenAllowed(Object itemId, boolean areChildrenAllowed)
            throws UnsupportedOperationException {
        return hierarchical.setChildrenAllowed(itemId, areChildrenAllowed);
    }

    @Override
    public boolean setParent(Object itemId, Object newParentId)
            throws UnsupportedOperationException {
        return hierarchical.setParent(itemId, newParentId);
    }

}
