/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util.converter;

import com.vaadin.server.VaadinSession;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.data.util.converter.ConverterFactory;
import com.vaadin.v7.data.util.converter.DefaultConverterFactory;
import java.io.Serializable;
import java.util.Locale;

@Deprecated
public class ConverterUtil
implements Serializable {
    public static <PRESENTATIONTYPE, MODELTYPE> Converter<PRESENTATIONTYPE, MODELTYPE> getConverter(Class<PRESENTATIONTYPE> presentationType, Class<MODELTYPE> modelType, VaadinSession session) {
        Converter<PRESENTATIONTYPE, MODELTYPE> converter = null;
        if (session == null) {
            session = VaadinSession.getCurrent();
        }
        if (session != null) {
            ConverterFactory factory = (ConverterFactory)session.getConverterFactory();
            if (factory == null) {
                factory = new DefaultConverterFactory();
                session.setConverterFactory((Object)factory);
            }
            converter = factory.createConverter(presentationType, modelType);
        }
        return converter;
    }

    public static <PRESENTATIONTYPE, MODELTYPE> PRESENTATIONTYPE convertFromModel(MODELTYPE modelValue, Class<? extends PRESENTATIONTYPE> presentationType, Converter<PRESENTATIONTYPE, MODELTYPE> converter, Locale locale) throws Converter.ConversionException {
        if (converter != null) {
            PRESENTATIONTYPE presentation = converter.convertToPresentation(modelValue, presentationType, locale);
            if (presentation != null && !presentationType.isInstance(presentation)) {
                throw new Converter.ConversionException("Converter returned an object of type " + presentation.getClass().getName() + " when expecting " + presentationType.getName());
            }
            return presentation;
        }
        if (modelValue == null) {
            return null;
        }
        if (presentationType.isAssignableFrom(modelValue.getClass())) {
            return (PRESENTATIONTYPE)modelValue;
        }
        throw new Converter.ConversionException("Unable to convert value of type " + modelValue.getClass().getName() + " to presentation type " + presentationType + ". No converter is set and the types are not compatible.");
    }

    public static <MODELTYPE, PRESENTATIONTYPE> MODELTYPE convertToModel(PRESENTATIONTYPE presentationValue, Class<MODELTYPE> modelType, Converter<PRESENTATIONTYPE, MODELTYPE> converter, Locale locale) throws Converter.ConversionException {
        if (converter != null) {
            MODELTYPE model = converter.convertToModel(presentationValue, modelType, locale);
            if (model != null && !modelType.isInstance(model)) {
                throw new Converter.ConversionException("Converter returned an object of type " + model.getClass().getName() + " when expecting " + modelType.getName());
            }
            return model;
        }
        if (presentationValue == null) {
            return null;
        }
        if (modelType == null) {
            return (MODELTYPE)presentationValue;
        }
        if (modelType.isAssignableFrom(presentationValue.getClass())) {
            return modelType.cast(presentationValue);
        }
        throw new Converter.ConversionException("Unable to convert value of type " + presentationValue.getClass().getName() + " to model type " + modelType + ". No converter is set and the types are not compatible.");
    }

    public static boolean canConverterHandle(Converter<?, ?> converter, Class<?> presentationType, Class<?> modelType) {
        if (converter == null) {
            return false;
        }
        if (modelType != converter.getModelType()) {
            return false;
        }
        return presentationType == converter.getPresentationType();
    }

    public static boolean canConverterPossiblyHandle(Converter<?, ?> converter, Class<?> presentationType, Class<?> modelType) {
        if (converter == null) {
            return false;
        }
        Class<?> converterModelType = converter.getModelType();
        if (!modelType.isAssignableFrom(converterModelType) && !converterModelType.isAssignableFrom(modelType)) {
            return false;
        }
        Class<?> converterPresentationType = converter.getPresentationType();
        return presentationType.isAssignableFrom(converterPresentationType) || converterPresentationType.isAssignableFrom(presentationType);
    }
}

