/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.ui;

import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Component;

/**
 * Vertical layout
 *
 * <code>VerticalLayout</code> is a component container, which shows the
 * subcomponents in the order of their addition (vertically). A vertical layout
 * is by default 100% wide.
 * <p>
 * This class is a compatibility version that uses the old defaults (no spacing
 * or margins), whereas the defaults of {@link com.vaadin.ui.VerticalLayout}
 * have changed.
 *
 * @author Vaadin Ltd.
 * @since 5.3
 *
 * @deprecated Replaced in 8.0 with {@link com.vaadin.ui.VerticalLayout} with
 *             margin and spacing on by default
 */
@Deprecated
public class VerticalLayout extends com.vaadin.ui.VerticalLayout {
    /**
     * Constructs an empty VerticalLayout.
     */
    public VerticalLayout() {
        super();
        setSpacing(false);
        setMargin(false);
    }

    /**
     * Constructs a VerticalLayout with the given components. The components are
     * added in the given order.
     *
     * @see AbstractOrderedLayout#addComponents(Component...)
     *
     * @param children
     *            The components to add.
     */
    public VerticalLayout(Component... children) {
        this();
        addComponents(children);
    }

}
