/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui.components.colorpicker;

import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.colorpicker.Color;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeEvent;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeListener;
import com.vaadin.v7.ui.components.colorpicker.ColorSelector;
import java.lang.reflect.Method;
import java.util.EventObject;

@Deprecated
public class ColorPickerPreview
extends CssLayout
implements ColorSelector,
Property.ValueChangeListener {
    private static final String STYLE_DARK_COLOR = "v-textfield-dark";
    private static final String STYLE_LIGHT_COLOR = "v-textfield-light";
    private static final Method COLOR_CHANGE_METHOD;
    private Color color;
    private final TextField field;
    private String oldValue;

    private ColorPickerPreview() {
        this.setStyleName("v-colorpicker-preview");
        this.field = new TextField();
        this.field.setImmediate(true);
        this.field.setSizeFull();
        this.field.setStyleName("v-colorpicker-preview-textfield");
        this.field.setData(this);
        this.field.addValueChangeListener(this);
        this.addComponent((Component)this.field);
    }

    public ColorPickerPreview(Color color) {
        this();
        this.setColor(color);
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        this.field.removeValueChangeListener(this);
        String colorCSS = color.getCSS();
        this.field.setValue(colorCSS);
        if (this.field.isValid()) {
            this.oldValue = colorCSS;
        } else {
            this.field.setValue(this.oldValue);
        }
        this.field.addValueChangeListener(this);
        this.field.removeStyleName(STYLE_DARK_COLOR);
        this.field.removeStyleName(STYLE_LIGHT_COLOR);
        if (this.color.getRed() + this.color.getGreen() + this.color.getBlue() < 384) {
            this.field.addStyleName(STYLE_DARK_COLOR);
        } else {
            this.field.addStyleName(STYLE_LIGHT_COLOR);
        }
        this.markAsDirty();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void addColorChangeListener(ColorChangeListener listener) {
        this.addListener(ColorChangeEvent.class, listener, COLOR_CHANGE_METHOD);
    }

    @Override
    public void removeColorChangeListener(ColorChangeListener listener) {
        this.removeListener(ColorChangeEvent.class, listener);
    }

    @Override
    public void valueChange(Property.ValueChangeEvent event) {
        String value = (String)event.getProperty().getValue();
        try {
            if (value != null) {
                if (value.length() == 7 && value.startsWith("#")) {
                    int red = Integer.parseInt(value.substring(1, 3), 16);
                    int green = Integer.parseInt(value.substring(3, 5), 16);
                    int blue = Integer.parseInt(value.substring(5, 7), 16);
                    this.color = new Color(red, green, blue);
                } else if (value.startsWith("rgb")) {
                    String[] colors = value.substring(value.indexOf("(") + 1, value.length() - 1).split(",");
                    int red = Integer.parseInt(colors[0]);
                    int green = Integer.parseInt(colors[1]);
                    int blue = Integer.parseInt(colors[2]);
                    if (colors.length > 3) {
                        int alpha = (int)(Double.parseDouble(colors[3]) * 255.0);
                        this.color = new Color(red, green, blue, alpha);
                    } else {
                        this.color = new Color(red, green, blue);
                    }
                } else if (value.startsWith("hsl")) {
                    String[] colors = value.substring(value.indexOf("(") + 1, value.length() - 1).split(",");
                    int hue = Integer.parseInt(colors[0]);
                    int saturation = Integer.parseInt(colors[1].replace("%", ""));
                    int lightness = Integer.parseInt(colors[2].replace("%", ""));
                    int rgb = Color.HSLtoRGB((int)hue, (int)saturation, (int)lightness);
                    if (colors.length > 3) {
                        int alpha = (int)(Double.parseDouble(colors[3]) * 255.0);
                        this.color = new Color(rgb);
                        this.color.setAlpha(alpha);
                    } else {
                        this.color = new Color(rgb);
                    }
                }
                this.oldValue = value;
                this.fireEvent((EventObject)((Object)new ColorChangeEvent((Component)this.field.getData(), this.color)));
            }
        }
        catch (NumberFormatException nfe) {
            this.field.setValue(this.oldValue);
        }
    }

    protected String getCss(Component c) {
        return "background: " + this.color.getCSS();
    }

    static {
        try {
            COLOR_CHANGE_METHOD = ColorChangeListener.class.getDeclaredMethod("colorChanged", ColorChangeEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in ColorPicker");
        }
    }
}

