/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.ui.declarative.DesignAttributeHandler;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.v7.shared.ui.colorpicker.Color;
import com.vaadin.v7.shared.ui.colorpicker.ColorPickerServerRpc;
import com.vaadin.v7.shared.ui.colorpicker.ColorPickerState;
import com.vaadin.v7.ui.AbstractLegacyComponent;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeEvent;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeListener;
import com.vaadin.v7.ui.components.colorpicker.ColorPickerPopup;
import com.vaadin.v7.ui.components.colorpicker.ColorSelector;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventObject;
import java.util.Locale;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

@Deprecated
public abstract class AbstractColorPicker
extends AbstractLegacyComponent
implements Window.CloseListener,
ColorSelector {
    private static final Method COLOR_CHANGE_METHOD;
    private ColorPickerServerRpc rpc = new ColorPickerServerRpc(){

        public void openPopup(boolean open) {
            AbstractColorPicker.this.showPopup(open);
        }
    };
    protected static final String STYLENAME_DEFAULT = "v-colorpicker";
    protected static final String STYLENAME_BUTTON = "v-button";
    protected static final String STYLENAME_AREA = "v-colorpicker-area";
    protected PopupStyle popupStyle = PopupStyle.POPUP_NORMAL;
    private ColorPickerPopup window;
    protected Color color;
    private UI parent;
    protected String popupCaption = null;
    private int positionX = 0;
    private int positionY = 0;
    protected boolean rgbVisible = true;
    protected boolean hsvVisible = true;
    protected boolean swatchesVisible = true;
    protected boolean historyVisible = true;
    protected boolean textfieldVisible = true;

    public AbstractColorPicker() {
        this("Colors", Color.WHITE);
    }

    public AbstractColorPicker(String popupCaption) {
        this(popupCaption, Color.WHITE);
    }

    public AbstractColorPicker(String popupCaption, Color initialColor) {
        this.registerRpc((ServerRpc)this.rpc);
        this.setColor(initialColor);
        this.popupCaption = popupCaption;
        this.setDefaultStyles();
        this.setCaption("");
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        if (this.window != null) {
            this.window.setColor(color);
        }
        this.getState().color = color.getCSS();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public void setDefaultCaptionEnabled(boolean enabled) {
        this.getState().showDefaultCaption = enabled;
    }

    public boolean isDefaultCaptionEnabled() {
        return this.getState((boolean)false).showDefaultCaption;
    }

    public void setPosition(int x, int y) {
        this.positionX = x;
        this.positionY = y;
        if (this.window != null) {
            this.window.setPositionX(x);
            this.window.setPositionY(y);
        }
    }

    @Override
    public void addColorChangeListener(ColorChangeListener listener) {
        this.addListener(ColorChangeEvent.class, listener, COLOR_CHANGE_METHOD);
    }

    @Override
    public void removeColorChangeListener(ColorChangeListener listener) {
        this.removeListener(ColorChangeEvent.class, listener);
    }

    public void windowClose(Window.CloseEvent e) {
        if (e.getWindow() == this.window) {
            this.getState().popupVisible = false;
        }
    }

    protected void colorChanged(ColorChangeEvent event) {
        this.setColor(event.getColor());
        this.fireColorChanged();
    }

    public void fireColorChanged() {
        this.fireEvent((EventObject)((Object)new ColorChangeEvent((Component)this, this.color)));
    }

    public void setPopupStyle(PopupStyle style) {
        this.popupStyle = style;
        switch (style) {
            case POPUP_NORMAL: {
                this.setRGBVisibility(true);
                this.setHSVVisibility(true);
                this.setSwatchesVisibility(true);
                this.setHistoryVisibility(true);
                this.setTextfieldVisibility(true);
                break;
            }
            case POPUP_SIMPLE: {
                this.setRGBVisibility(false);
                this.setHSVVisibility(false);
                this.setSwatchesVisibility(true);
                this.setHistoryVisibility(false);
                this.setTextfieldVisibility(false);
            }
        }
    }

    public PopupStyle getPopupStyle() {
        return this.popupStyle;
    }

    public void setRGBVisibility(boolean visible) {
        if (!(visible || this.hsvVisible || this.swatchesVisible)) {
            throw new IllegalArgumentException("Cannot hide all tabs.");
        }
        this.rgbVisible = visible;
        if (this.window != null) {
            this.window.setRGBTabVisible(visible);
        }
    }

    public boolean getRGBVisibility() {
        return this.rgbVisible;
    }

    public void setHSVVisibility(boolean visible) {
        if (!(visible || this.rgbVisible || this.swatchesVisible)) {
            throw new IllegalArgumentException("Cannot hide all tabs.");
        }
        this.hsvVisible = visible;
        if (this.window != null) {
            this.window.setHSVTabVisible(visible);
        }
    }

    public boolean getHSVVisibility() {
        return this.hsvVisible;
    }

    public void setSwatchesVisibility(boolean visible) {
        if (!(visible || this.hsvVisible || this.rgbVisible)) {
            throw new IllegalArgumentException("Cannot hide all tabs.");
        }
        this.swatchesVisible = visible;
        if (this.window != null) {
            this.window.setSwatchesTabVisible(visible);
        }
    }

    public boolean getSwatchesVisibility() {
        return this.swatchesVisible;
    }

    public void setHistoryVisibility(boolean visible) {
        this.historyVisible = visible;
        if (this.window != null) {
            this.window.setHistoryVisible(visible);
        }
    }

    public boolean getHistoryVisibility() {
        return this.historyVisible;
    }

    public void setTextfieldVisibility(boolean visible) {
        this.textfieldVisible = visible;
        if (this.window != null) {
            this.window.setPreviewVisible(visible);
        }
    }

    public boolean getTextfieldVisibility() {
        return this.textfieldVisible;
    }

    protected ColorPickerState getState() {
        return (ColorPickerState)super.getState();
    }

    protected ColorPickerState getState(boolean markAsDirty) {
        return (ColorPickerState)super.getState(markAsDirty);
    }

    protected abstract void setDefaultStyles();

    public void showPopup() {
        this.showPopup(true);
    }

    public void hidePopup() {
        this.showPopup(false);
    }

    protected void showPopup(boolean open) {
        if (open && !this.isReadOnly()) {
            if (this.parent == null) {
                this.parent = this.getUI();
            }
            if (this.window == null) {
                this.window = new ColorPickerPopup(this.color);
                this.window.setCaption(this.popupCaption);
                this.window.setRGBTabVisible(this.rgbVisible);
                this.window.setHSVTabVisible(this.hsvVisible);
                this.window.setSwatchesTabVisible(this.swatchesVisible);
                this.window.setHistoryVisible(this.historyVisible);
                this.window.setPreviewVisible(this.textfieldVisible);
                this.window.addCloseListener(this);
                this.window.addColorChangeListener(new ColorChangeListener(){

                    @Override
                    public void colorChanged(ColorChangeEvent event) {
                        AbstractColorPicker.this.colorChanged(event);
                    }
                });
                this.window.getHistory().setColor(this.color);
                this.parent.addWindow((Window)this.window);
                this.window.setVisible(true);
                this.window.setPositionX(this.positionX);
                this.window.setPositionY(this.positionY);
            } else if (!this.parent.equals((Object)this.window.getParent())) {
                this.window.setRGBTabVisible(this.rgbVisible);
                this.window.setHSVTabVisible(this.hsvVisible);
                this.window.setSwatchesTabVisible(this.swatchesVisible);
                this.window.setHistoryVisible(this.historyVisible);
                this.window.setPreviewVisible(this.textfieldVisible);
                this.window.setColor(this.color);
                this.window.getHistory().setColor(this.color);
                this.window.setVisible(true);
                this.parent.addWindow((Window)this.window);
            }
        } else if (this.window != null) {
            this.window.setVisible(false);
            this.parent.removeWindow((Window)this.window);
        }
        this.getState().popupVisible = open;
    }

    @Deprecated
    public void setHtmlContentAllowed(boolean htmlContentAllowed) {
        this.setCaptionAsHtml(htmlContentAllowed);
    }

    @Deprecated
    public boolean isHtmlContentAllowed() {
        return this.isCaptionAsHtml();
    }

    @Override
    public void readDesign(Element design, DesignContext designContext) {
        super.readDesign(design, designContext);
        Attributes attributes = design.attributes();
        if (design.hasAttr("color")) {
            String hexColor = ((String)DesignAttributeHandler.readAttribute((String)"color", (Attributes)attributes, String.class)).substring(1);
            this.setColor(new Color(Integer.parseInt(hexColor, 16)));
        }
        if (design.hasAttr("popup-style")) {
            this.setPopupStyle(PopupStyle.valueOf("POPUP_" + attributes.get("popup-style").toUpperCase(Locale.ROOT)));
        }
        if (design.hasAttr("position")) {
            String[] position = attributes.get("position").split(",");
            this.setPosition(Integer.parseInt(position[0]), Integer.parseInt(position[1]));
        }
    }

    @Override
    public void writeDesign(Element design, DesignContext designContext) {
        super.writeDesign(design, designContext);
        Attributes attribute = design.attributes();
        DesignAttributeHandler.writeAttribute((String)"color", (Attributes)attribute, (Object)this.color.getCSS(), (Object)Color.WHITE.getCSS(), String.class, (DesignContext)designContext);
        DesignAttributeHandler.writeAttribute((String)"popup-style", (Attributes)attribute, (Object)(this.popupStyle == PopupStyle.POPUP_NORMAL ? "normal" : "simple"), (Object)"normal", String.class, (DesignContext)designContext);
        DesignAttributeHandler.writeAttribute((String)"position", (Attributes)attribute, (Object)(this.positionX + "," + this.positionY), (Object)"0,0", String.class, (DesignContext)designContext);
    }

    protected Collection<String> getCustomAttributes() {
        Collection result = super.getCustomAttributes();
        result.add("color");
        result.add("position");
        result.add("popup-style");
        return result;
    }

    static {
        try {
            COLOR_CHANGE_METHOD = ColorChangeListener.class.getDeclaredMethod("colorChanged", ColorChangeEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in ColorPicker");
        }
    }

    @Deprecated
    public static enum PopupStyle {
        POPUP_NORMAL("normal"),
        POPUP_SIMPLE("simple");

        private String style;

        private PopupStyle(String styleName) {
            this.style = styleName;
        }

        public String toString() {
            return this.style;
        }
    }

    @Deprecated
    public static interface Coordinates2Color
    extends Serializable {
        public Color calculate(int var1, int var2);

        public int[] calculate(Color var1);
    }
}

