/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.ui;

import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Component;

/**
 * Horizontal layout
 *
 * <code>HorizontalLayout</code> is a component container, which shows the
 * subcomponents in the order of their addition (horizontally).
 * <p>
 * This class is a compatibility version that uses the old defaults (no
 * spacing), whereas the defaults of {@link com.vaadin.ui.HorizontalLayout} have
 * changed.
 *
 * @author Vaadin Ltd.
 * @since 5.3
 *
 * @deprecated Replaced in 8.0 with {@link com.vaadin.ui.HorizontalLayout} with
 *             spacing on by default
 */
@Deprecated
@SuppressWarnings("serial")
public class HorizontalLayout extends com.vaadin.ui.HorizontalLayout {
    /**
     * Constructs an empty HorizontalLayout.
     */
    public HorizontalLayout() {
        super();
        setSpacing(false);
    }

    /**
     * Constructs a HorizontalLayout with the given components. The components
     * are added in the given order.
     *
     * @see AbstractOrderedLayout#addComponents(Component...)
     *
     * @param children
     *            The components to add.
     */
    public HorizontalLayout(Component... children) {
        this();
        addComponents(children);
    }

}
