/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.data.util.filter;

import com.vaadin.data.provider.Query;

/**
 * Exception for cases where a container does not support a specific type of
 * filters.
 *
 * If possible, this should be thrown already when adding a filter to a
 * container. If a problem is not detected at that point, an
 * {@link UnsupportedOperationException} can be throws when attempting to
 * perform filtering.
 *
 * @since 6.6
 *
 * @deprecated As of 8.0, no replacement available. See {@link Query#getFilter()}
 */
@Deprecated
public class UnsupportedFilterException extends RuntimeException {

    public UnsupportedFilterException() {
    }

    public UnsupportedFilterException(String message) {
        super(message);
    }

    public UnsupportedFilterException(Exception cause) {
        super(cause);
    }

    public UnsupportedFilterException(String message, Exception cause) {
        super(message, cause);
    }
}
