/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.apphosting.api.DeadlineExceededException;
import com.vaadin.server.ServiceException;
import com.vaadin.server.ServletPortletHelper;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletRequest;
import com.vaadin.server.VaadinServletResponse;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.WrappedHttpSession;
import com.vaadin.server.WrappedSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@Deprecated
public class GAEVaadinServlet
extends VaadinServlet {
    private static final String MUTEX_BASE = "_vmutex";
    private static final String AC_BASE = "_vac";
    private static final int MAX_UIDL_WAIT_MILLISECONDS = 5000;
    private static final int RETRY_AFTER_MILLISECONDS = 100;
    private static final String PROPERTY_EXPIRES = "expires";
    private static final String PROPERTY_DATA = "data";
    private static final String CLEANUP_PATH = "/CLEAN";
    private static final int CLEANUP_LIMIT = 200;
    private static final String APPENGINE_SESSION_KIND = "_ah_SESSION";
    private static final String PROPERTY_APPENGINE_EXPIRES = "_expires";
    private static final int DEFAULT_MAX_INACTIVE_INTERVAL = 86400;

    protected void sendDeadlineExceededNotification(VaadinServletRequest request, VaadinServletResponse response) throws IOException {
        this.criticalNotification(request, response, "Deadline Exceeded", "I'm sorry, but the operation took too long to complete. We'll try reloading to see where we're at, please take note of any unsaved data...", "", null);
    }

    protected void sendNotSerializableNotification(VaadinServletRequest request, VaadinServletResponse response) throws IOException {
        this.criticalNotification(request, response, "NotSerializableException", "I'm sorry, but there seems to be a serious problem, please contact the administrator. And please take note of any unsaved data...", "", this.getApplicationUrl((HttpServletRequest)request) + "?restartApplication");
    }

    protected void sendCriticalErrorNotification(VaadinServletRequest request, VaadinServletResponse response) throws IOException {
        this.criticalNotification(request, response, "Critical error", "I'm sorry, but there seems to be a serious problem, please contact the administrator. And please take note of any unsaved data...", "", this.getApplicationUrl((HttpServletRequest)request) + "?restartApplication");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest unwrappedRequest, HttpServletResponse unwrappedResponse) throws ServletException, IOException {
        VaadinServletRequest request = new VaadinServletRequest(unwrappedRequest, this.getService());
        VaadinServletResponse response = new VaadinServletResponse(unwrappedResponse, this.getService());
        if (this.isCleanupRequest((HttpServletRequest)request)) {
            this.cleanDatastore();
            return;
        }
        if (this.isStaticResourceRequest((HttpServletRequest)request)) {
            super.service((HttpServletRequest)request, (HttpServletResponse)response);
            this.cleanSession(request);
            return;
        }
        if (ServletPortletHelper.isAppRequest((VaadinRequest)request)) {
            this.getApplicationContext((HttpServletRequest)request, MemcacheServiceFactory.getMemcacheService());
            super.service((HttpServletRequest)request, (HttpServletResponse)response);
            this.cleanSession(request);
            return;
        }
        HttpSession session = request.getSession(this.getService().requestCanCreateSession((VaadinRequest)request));
        if (session == null) {
            try {
                this.getService().handleSessionExpired((VaadinRequest)request, (VaadinResponse)response);
            }
            catch (ServiceException e) {
                throw new ServletException((Throwable)e);
            }
            this.cleanSession(request);
            return;
        }
        boolean locked = false;
        String mutex = MUTEX_BASE + session.getId();
        MemcacheService memcache = MemcacheServiceFactory.getMemcacheService();
        try {
            long started = System.currentTimeMillis();
            while (System.currentTimeMillis() - started < 5000L && !(locked = memcache.put((Object)mutex, (Object)1, Expiration.byDeltaSeconds((int)40), MemcacheService.SetPolicy.ADD_ONLY_IF_NOT_PRESENT)) && !ServletPortletHelper.isUIDLRequest((VaadinRequest)request)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    GAEVaadinServlet.getLogger().finer("Thread.sleep() interrupted while waiting for lock. Trying again. " + e);
                }
            }
            if (!locked) {
                response.setStatus(503);
                response.setHeader("Retry-After", "100");
                return;
            }
            VaadinSession ctx = this.getApplicationContext((HttpServletRequest)request, memcache);
            super.service((HttpServletRequest)request, (HttpServletResponse)response);
            started = new Date().getTime();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(ctx);
            oos.flush();
            byte[] bytes = baos.toByteArray();
            started = new Date().getTime();
            String id = AC_BASE + session.getId();
            Date expire = new Date(started + (long)(this.getMaxInactiveIntervalSeconds(session) * 1000));
            Expiration expires = Expiration.onDate((Date)expire);
            memcache.put((Object)id, (Object)bytes, expires);
            DatastoreService ds = DatastoreServiceFactory.getDatastoreService();
            Entity entity = new Entity(AC_BASE, id);
            entity.setProperty(PROPERTY_EXPIRES, (Object)expire.getTime());
            entity.setProperty(PROPERTY_DATA, (Object)new Blob(bytes));
            ds.put(entity);
        }
        catch (DeadlineExceededException e) {
            GAEVaadinServlet.getLogger().log(Level.WARNING, "DeadlineExceeded for {0}", session.getId());
            this.sendDeadlineExceededNotification(request, response);
        }
        catch (NotSerializableException e) {
            GAEVaadinServlet.getLogger().log(Level.SEVERE, "Not serializable!", e);
            this.sendNotSerializableNotification(request, response);
        }
        catch (Exception e) {
            GAEVaadinServlet.getLogger().log(Level.WARNING, "An exception occurred while servicing request.", e);
            this.sendCriticalErrorNotification(request, response);
        }
        finally {
            if (locked) {
                memcache.delete((Object)mutex);
            }
            this.cleanSession(request);
        }
    }

    protected int getMaxInactiveIntervalSeconds(HttpSession session) {
        int interval = session.getMaxInactiveInterval();
        if (interval <= 0) {
            GAEVaadinServlet.getLogger().log(Level.FINE, "Undefined session expiration time, using default value instead.");
            return 86400;
        }
        return interval;
    }

    protected VaadinSession getApplicationContext(HttpServletRequest request, MemcacheService memcache) throws ServletException {
        HttpSession session = request.getSession();
        String id = AC_BASE + session.getId();
        byte[] serializedAC = (byte[])memcache.get((Object)id);
        if (serializedAC == null) {
            DatastoreService ds = DatastoreServiceFactory.getDatastoreService();
            Key key = KeyFactory.createKey((String)AC_BASE, (String)id);
            Entity entity = null;
            try {
                entity = ds.get(key);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
            if (entity != null) {
                Blob blob = (Blob)entity.getProperty(PROPERTY_DATA);
                serializedAC = blob.getBytes();
                memcache.put((Object)(AC_BASE + session.getId()), (Object)serializedAC, Expiration.byDeltaSeconds((int)this.getMaxInactiveIntervalSeconds(session)), MemcacheService.SetPolicy.ADD_ONLY_IF_NOT_PRESENT);
            }
        }
        if (serializedAC != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedAC);
            try {
                ObjectInputStream ois = new ObjectInputStream(bais);
                VaadinSession vaadinSession = (VaadinSession)ois.readObject();
                this.getService().storeSession(vaadinSession, (WrappedSession)new WrappedHttpSession(session));
            }
            catch (IOException e) {
                GAEVaadinServlet.getLogger().log(Level.WARNING, "Could not de-serialize ApplicationContext for " + session.getId() + " A new one will be created. ", e);
            }
            catch (ClassNotFoundException e) {
                GAEVaadinServlet.getLogger().log(Level.WARNING, "Could not de-serialize ApplicationContext for " + session.getId() + " A new one will be created. ", e);
            }
        }
        try {
            return this.getService().findVaadinSession((VaadinRequest)this.createVaadinRequest(request));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private boolean isCleanupRequest(HttpServletRequest request) {
        String path = request.getPathInfo();
        return path != null && path.equals(CLEANUP_PATH);
    }

    private void cleanSession(VaadinServletRequest request) {
        WrappedSession wrappedSession = request.getWrappedSession(false);
        if (wrappedSession == null) {
            return;
        }
        VaadinSession serviceSession = this.getService().loadSession(wrappedSession);
        if (serviceSession == null) {
            return;
        }
        serviceSession.setAttribute(VaadinService.PRESERVE_UNBOUND_SESSION_ATTRIBUTE, (Object)Boolean.TRUE);
        this.getService().removeSession(serviceSession.getSession());
        serviceSession.setAttribute(VaadinService.PRESERVE_UNBOUND_SESSION_ATTRIBUTE, null);
    }

    private void cleanDatastore() {
        long expire = new Date().getTime();
        try {
            ArrayList<Key> keys;
            DatastoreService ds = DatastoreServiceFactory.getDatastoreService();
            Query q = new Query(AC_BASE);
            q.setKeysOnly();
            q.addFilter(PROPERTY_EXPIRES, Query.FilterOperator.LESS_THAN_OR_EQUAL, (Object)expire);
            PreparedQuery pq = ds.prepare(q);
            List entities = pq.asList(FetchOptions.Builder.withLimit((int)200));
            if (entities != null) {
                GAEVaadinServlet.getLogger().log(Level.INFO, "Vaadin cleanup deleting {0} expired Vaadin sessions.", entities.size());
                keys = new ArrayList<Key>();
                for (Entity e : entities) {
                    keys.add(e.getKey());
                }
                ds.delete(keys);
            }
            q = new Query(APPENGINE_SESSION_KIND);
            q.setKeysOnly();
            q.addFilter(PROPERTY_APPENGINE_EXPIRES, Query.FilterOperator.LESS_THAN_OR_EQUAL, (Object)expire);
            pq = ds.prepare(q);
            entities = pq.asList(FetchOptions.Builder.withLimit((int)200));
            if (entities != null) {
                GAEVaadinServlet.getLogger().log(Level.INFO, "Vaadin cleanup deleting {0} expired appengine sessions.", entities.size());
                keys = new ArrayList();
                for (Entity e : entities) {
                    keys.add(e.getKey());
                }
                ds.delete(keys);
            }
        }
        catch (Exception e) {
            GAEVaadinServlet.getLogger().log(Level.WARNING, "Exception while cleaning.", e);
        }
    }

    private static final Logger getLogger() {
        return Logger.getLogger(GAEVaadinServlet.class.getName());
    }
}

