/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.v7.client.ui.nativeselect;

import com.vaadin.client.ui.ConnectorFocusAndBlurHandler;
import com.vaadin.shared.ui.Connect;
import com.vaadin.v7.client.ui.VNativeSelect;
import com.vaadin.v7.client.ui.optiongroup.OptionGroupBaseConnector;
import com.vaadin.v7.ui.NativeSelect;

@Connect(NativeSelect.class)
public class NativeSelectConnector extends OptionGroupBaseConnector {

    @Override
    protected void init() {
        super.init();
        ConnectorFocusAndBlurHandler.addHandlers(this, getWidget().getSelect());
    }

    @Override
    public VNativeSelect getWidget() {
        return (VNativeSelect) super.getWidget();
    }
}
