/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.client.connectors;

import com.google.web.bindery.event.shared.HandlerRegistration;
import com.vaadin.shared.ui.Connect;
import com.vaadin.v7.client.renderers.ButtonRenderer;
import com.vaadin.v7.client.renderers.ClickableRenderer.RendererClickHandler;

import elemental.json.JsonObject;

/**
 * A connector for {@link ButtonRenderer}.
 *
 * @since 7.4
 * @author Vaadin Ltd
 */
@Connect(com.vaadin.v7.ui.renderers.ButtonRenderer.class)
public class ButtonRendererConnector
        extends ClickableRendererConnector<String> {

    @Override
    public ButtonRenderer getRenderer() {
        return (ButtonRenderer) super.getRenderer();
    }

    @Override
    protected HandlerRegistration addClickHandler(
            RendererClickHandler<JsonObject> handler) {
        return getRenderer().addClickHandler(handler);
    }
}
