/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.client.connectors;

import com.vaadin.shared.ui.Connect;
import com.vaadin.v7.client.renderers.ProgressBarRenderer;

/**
 * A connector for {@link ProgressBarRenderer}.
 *
 * @since 7.4
 * @author Vaadin Ltd
 */
@Connect(com.vaadin.v7.ui.renderers.ProgressBarRenderer.class)
public class ProgressBarRendererConnector
        extends AbstractGridRendererConnector<Double> {

    @Override
    public ProgressBarRenderer getRenderer() {
        return (ProgressBarRenderer) super.getRenderer();
    }
}
