/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox.dataview;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.combobox.ComboBoxBase;
import com.vaadin.flow.data.provider.AbstractListDataView;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.util.stream.Stream;

public class ComboBoxListDataView<T>
extends AbstractListDataView<T> {
    private final DataCommunicator<T> dataCommunicator;

    public ComboBoxListDataView(DataCommunicator<T> dataCommunicator, ComboBoxBase<?, T, ?> comboBox, SerializableBiConsumer<SerializablePredicate<T>, SerializableComparator<T>> filterOrSortingChangedCallback) {
        super(() -> dataCommunicator.getDataProvider(), comboBox, filterOrSortingChangedCallback);
        this.dataCommunicator = dataCommunicator;
    }

    public Stream<T> getItems() {
        return this.getDataProvider().fetch(this.getQuery());
    }

    public int getItemCount() {
        return this.getDataProvider().size(this.getQuery());
    }

    public void setIdentifierProvider(IdentifierProvider<T> identifierProvider) {
        super.setIdentifierProvider(identifierProvider);
        this.dataCommunicator.getKeyMapper().setIdentifierGetter(identifierProvider);
    }

    public Registration addItemCountChangeListener(ComponentEventListener<ItemCountChangeEvent<?>> listener) {
        return super.addItemCountChangeListener(listener);
    }

    public ComboBoxListDataView<T> addFilter(SerializablePredicate<T> filter) {
        return (ComboBoxListDataView)super.addFilter(filter);
    }

    public ComboBoxListDataView<T> removeFilters() {
        return (ComboBoxListDataView)super.removeFilters();
    }

    public ComboBoxListDataView<T> setFilter(SerializablePredicate<T> filter) {
        return (ComboBoxListDataView)super.setFilter(filter);
    }

    private Query getQuery() {
        return this.dataCommunicator.buildQuery(0, Integer.MAX_VALUE);
    }
}

