/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasPlaceholder;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.ComboBoxBaseI18n;
import com.vaadin.flow.component.combobox.ComboBoxDataCommunicator;
import com.vaadin.flow.component.combobox.ComboBoxDataController;
import com.vaadin.flow.component.combobox.ComboBoxRenderManager;
import com.vaadin.flow.component.combobox.dataview.ComboBoxDataView;
import com.vaadin.flow.component.combobox.dataview.ComboBoxLazyDataView;
import com.vaadin.flow.component.combobox.dataview.ComboBoxListDataView;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasAutoOpen;
import com.vaadin.flow.component.shared.HasClearButton;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasLazyDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.spring.data.VaadinSpringDataHelpers;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public abstract class ComboBoxBase<TComponent extends ComboBoxBase<TComponent, TItem, TValue>, TItem, TValue>
extends AbstractSinglePropertyField<TComponent, TValue>
implements Focusable<TComponent>,
HasAllowedCharPattern,
HasAriaLabel,
HasAutoOpen,
HasClearButton,
HasDataView<TItem, String, ComboBoxDataView<TItem>>,
InputField<AbstractField.ComponentValueChangeEvent<TComponent, TValue>, TValue>,
HasLazyDataView<TItem, String, ComboBoxLazyDataView<TItem>>,
HasListDataView<TItem, ComboBoxListDataView<TItem>>,
HasTheme,
HasValidationProperties,
HasValidator<TValue>,
HasPlaceholder {
    private static final int DEFAULT_FILTER_TIMEOUT = 500;
    private ItemLabelGenerator<TItem> itemLabelGenerator = String::valueOf;
    private SerializableFunction<TItem, String> classNameGenerator = (SerializableFunction & Serializable)item -> null;
    private final ComboBoxRenderManager<TItem> renderManager;
    private final ComboBoxDataController<TItem> dataController;
    private int customValueListenersCount;
    private ComboBoxBaseI18n i18n;
    private Validator<TValue> defaultValidator = (Validator & Serializable)(value, context) -> {
        boolean fromComponent = context == null;
        boolean isRequired = fromComponent && this.isRequiredIndicatorVisible();
        return ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(ComboBoxBaseI18n::getRequiredErrorMessage), (boolean)isRequired, (Object)this.getValue(), (Object)this.getEmptyValue());
    };
    private ValidationController<ComboBoxBase<TComponent, TItem, TValue>, TValue> validationController = new ValidationController((Component)this);

    public <TValueProperty> ComboBoxBase(String valuePropertyName, TValue defaultValue, Class<TValueProperty> valuePropertyType, SerializableBiFunction<TComponent, TValueProperty, TValue> presentationToModel, SerializableBiFunction<TComponent, TValue, TValueProperty> modelToPresentation) {
        super(valuePropertyName, defaultValue, valuePropertyType, presentationToModel, modelToPresentation);
        this.getElement().setProperty("manualValidation", true);
        SerializableSupplier<Locale> localeSupplier = new SerializableSupplier<Locale>(){

            public Locale get() {
                return ComboBoxBase.this.getLocale();
            }
        };
        this.renderManager = new ComboBoxRenderManager(this);
        this.dataController = new ComboBoxDataController(this, localeSupplier);
        this.dataController.getDataGenerator().addDataGenerator((DataGenerator & Serializable)(item, jsonObject) -> jsonObject.put("label", this.generateLabel(item)));
        this.dataController.getDataGenerator().addDataGenerator((DataGenerator & Serializable)(item, jsonObject) -> jsonObject.put("className", this.generateClassName(item)));
        this.getElement().setProperty("itemValuePath", "key");
        this.getElement().setProperty("itemIdPath", "key");
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.getDataCommunicator().notifySelectionChanged());
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.setFilterTimeout(500);
    }

    public boolean isAutofocus() {
        return this.getElement().getProperty("autofocus", false);
    }

    public void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    public int getPageSize() {
        return this.getElement().getProperty("pageSize", 50);
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size should be greater than zero.");
        }
        this.getElement().setProperty("pageSize", (double)pageSize);
        this.dataController.setPageSize(pageSize);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setOpened(boolean opened) {
        this.getElement().setProperty("opened", opened);
    }

    public boolean isAllowCustomValue() {
        return this.getElement().getProperty("allowCustomValue", false);
    }

    public void setAllowCustomValue(boolean allowCustomValue) {
        this.getElement().setProperty("allowCustomValue", allowCustomValue);
    }

    @Synchronize(property="filter", value={"filter-changed"})
    protected String getFilter() {
        return this.getElement().getProperty("filter");
    }

    protected void setFilter(String filter) {
        this.getElement().setProperty("filter", filter == null ? "" : filter);
    }

    public void setFilterTimeout(int filterTimeout) {
        this.getElement().setProperty("_filterTimeout", (double)filterTimeout);
    }

    public int getFilterTimeout() {
        return this.getElement().getProperty("_filterTimeout", 500);
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public boolean isRequiredIndicatorVisible() {
        return super.isRequiredIndicatorVisible();
    }

    public boolean isRequired() {
        return this.isRequiredIndicatorVisible();
    }

    public void setRequired(boolean required) {
        this.setRequiredIndicatorVisible(required);
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setAriaLabelledBy(String labelledBy) {
        this.getElement().setProperty("accessibleNameRef", labelledBy);
    }

    public Optional<String> getAriaLabelledBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleNameRef"));
    }

    public void setItemLabelGenerator(ItemLabelGenerator<TItem> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator, "The item label generator can not be null");
        this.itemLabelGenerator = itemLabelGenerator;
        this.dataController.reset();
        if (this.getValue() != null) {
            this.refreshValue();
        }
    }

    public ItemLabelGenerator<TItem> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    protected String generateLabel(TItem item) {
        if (item == null) {
            return "";
        }
        String label = this.getItemLabelGenerator().apply(item);
        if (label == null) {
            throw new IllegalStateException(String.format("Got 'null' as a label value for the item '%s'. '%s' instance may not return 'null' values", item, ItemLabelGenerator.class.getSimpleName()));
        }
        return label;
    }

    public void setClassNameGenerator(SerializableFunction<TItem, String> classNameGenerator) {
        Objects.requireNonNull(classNameGenerator, "Class name generator can not be null");
        this.classNameGenerator = classNameGenerator;
        this.dataController.reset();
    }

    public SerializableFunction<TItem, String> getItemClassNameGenerator() {
        return this.classNameGenerator;
    }

    protected String generateClassName(TItem item) {
        if (item == null) {
            return "";
        }
        String label = (String)this.getItemClassNameGenerator().apply(item);
        if (label == null) {
            return "";
        }
        return label;
    }

    public void setRenderer(Renderer<TItem> renderer) {
        Objects.requireNonNull(renderer, "The renderer must not be null");
        this.renderManager.setRenderer(renderer);
    }

    public void setValue(TValue value) {
        if (this.getDataCommunicator() == null || this.getDataProvider() instanceof DataCommunicator.EmptyDataProvider) {
            if (this.valueEquals(value, this.getEmptyValue())) {
                return;
            }
            throw new IllegalStateException("Cannot set a value for a ComboBox without items. Use setItems to populate items into the ComboBox before setting a value.");
        }
        super.setValue(value);
        this.refreshValue();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        this.dataController.onAttach();
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.dataController.onDetach();
        super.onDetach(detachEvent);
    }

    public Registration addCustomValueSetListener(ComponentEventListener<CustomValueSetEvent<TComponent>> listener) {
        this.setAllowCustomValue(true);
        ++this.customValueListenersCount;
        Registration registration = this.addInternalCustomValueSetListener(listener);
        return new CustomValueRegistration(registration);
    }

    private Registration addInternalCustomValueSetListener(ComponentEventListener<CustomValueSetEvent<TComponent>> listener) {
        return this.addListener(CustomValueSetEvent.class, listener);
    }

    public ComboBoxListDataView<TItem> getListDataView() {
        return this.dataController.getListDataView();
    }

    public ComboBoxListDataView<TItem> setItems(Collection<TItem> items) {
        return (ComboBoxListDataView)this.dataController.setItems(items);
    }

    public ComboBoxListDataView<TItem> setItems(ComboBox.ItemFilter<TItem> itemFilter, Collection<TItem> items) {
        return this.dataController.setItems(itemFilter, items);
    }

    public ComboBoxListDataView<TItem> setItems(ComboBox.ItemFilter<TItem> itemFilter, TItem ... items) {
        return this.dataController.setItems(itemFilter, items);
    }

    public ComboBoxListDataView<TItem> setItems(ComboBox.ItemFilter<TItem> itemFilter, ListDataProvider<TItem> listDataProvider) {
        return this.dataController.setItems(itemFilter, listDataProvider);
    }

    public ComboBoxListDataView<TItem> setItems(ListDataProvider<TItem> dataProvider) {
        return this.dataController.setItems(dataProvider);
    }

    public ComboBoxLazyDataView<TItem> getLazyDataView() {
        return this.dataController.getLazyDataView();
    }

    public <C> ComboBoxLazyDataView<TItem> setItemsWithFilterConverter(CallbackDataProvider.FetchCallback<TItem, C> fetchCallback, SerializableFunction<String, C> filterConverter) {
        return this.dataController.setItemsWithFilterConverter(fetchCallback, filterConverter);
    }

    public <C> ComboBoxLazyDataView<TItem> setItemsWithFilterConverter(CallbackDataProvider.FetchCallback<TItem, C> fetchCallback, CallbackDataProvider.CountCallback<TItem, C> countCallback, SerializableFunction<String, C> filterConverter) {
        return this.dataController.setItemsWithFilterConverter(fetchCallback, countCallback, filterConverter);
    }

    public ComboBoxLazyDataView<TItem> setItems(CallbackDataProvider.FetchCallback<TItem, String> fetchCallback) {
        return (ComboBoxLazyDataView)super.setItems(fetchCallback);
    }

    public ComboBoxLazyDataView<TItem> setItems(CallbackDataProvider.FetchCallback<TItem, String> fetchCallback, CallbackDataProvider.CountCallback<TItem, String> countCallback) {
        return (ComboBoxLazyDataView)super.setItems(fetchCallback, countCallback);
    }

    public ComboBoxLazyDataView<TItem> setItemsPageable(SpringData.FetchCallback<Pageable, TItem> fetchCallback) {
        return this.setItems((CallbackDataProvider.FetchCallback<TItem, String>)(CallbackDataProvider.FetchCallback & Serializable)query -> ComboBoxBase.handleSpringFetchCallback(query, fetchCallback));
    }

    public ComboBoxLazyDataView<TItem> setItemsPageable(SpringData.FetchCallback<Pageable, TItem> fetchCallback, SpringData.CountCallback<Pageable> countCallback) {
        return this.setItems((CallbackDataProvider.FetchCallback<TItem, String>)(CallbackDataProvider.FetchCallback & Serializable)query -> ComboBoxBase.handleSpringFetchCallback(query, fetchCallback), (CallbackDataProvider.CountCallback<TItem, String>)(CallbackDataProvider.CountCallback & Serializable)query -> ComboBoxBase.handleSpringCountCallback(query, countCallback));
    }

    private static <PAGEABLE, T> Stream<T> handleSpringFetchCallback(Query<T, String> query, SpringData.FetchCallback<PAGEABLE, T> fetchCallback) {
        PageRequest pageable = VaadinSpringDataHelpers.toSpringPageRequest(query);
        List<T> itemList = fetchCallback.fetch(pageable, query.getFilter().orElse(""));
        return itemList.stream();
    }

    private static <PAGEABLE> int handleSpringCountCallback(Query<?, String> query, SpringData.CountCallback<PAGEABLE> countCallback) {
        PageRequest pageable = VaadinSpringDataHelpers.toSpringPageRequest(query);
        long count = countCallback.count(pageable, query.getFilter().orElse(""));
        if (count > Integer.MAX_VALUE) {
            LoggerFactory.getLogger(ComboBoxBase.class).warn("The count of items in the backend ({}) exceeds the maximum supported by the ComboBox.", (Object)count);
            return Integer.MAX_VALUE;
        }
        return (int)count;
    }

    public ComboBoxLazyDataView<TItem> setItems(BackEndDataProvider<TItem, String> dataProvider) {
        return this.dataController.setItems(dataProvider);
    }

    public ComboBoxDataView<TItem> getGenericDataView() {
        return this.dataController.getGenericDataView();
    }

    public ComboBoxDataView<TItem> setItems(DataProvider<TItem, String> dataProvider) {
        return this.dataController.setItems(dataProvider);
    }

    @Deprecated
    public ComboBoxDataView<TItem> setItems(InMemoryDataProvider<TItem> dataProvider) {
        throw new UnsupportedOperationException(String.format("ComboBox does not support setting a custom in-memory data provider without knowledge of the rules on how to convert internal text filter into a predicate applied to the data provider. Please use%nsetItems(InMemoryDataProvider<T>, SerializableFunction<String, SerializablePredicate<T>>)%noverloaded method instead", new Object[0]));
    }

    public ComboBoxDataView<TItem> setItems(InMemoryDataProvider<TItem> inMemoryDataProvider, SerializableFunction<String, SerializablePredicate<TItem>> filterConverter) {
        return this.dataController.setItems(inMemoryDataProvider, filterConverter);
    }

    public <C> void setDataProvider(DataProvider<TItem, C> dataProvider, SerializableFunction<String, C> filterConverter) {
        this.dataController.setDataProvider(dataProvider, filterConverter);
    }

    public void setDataProvider(ComboBox.FetchItemsCallback<TItem> fetchItems, SerializableFunction<String, Integer> sizeCallback) {
        this.dataController.setDataProvider(fetchItems, sizeCallback);
    }

    public DataProvider<TItem, ?> getDataProvider() {
        return this.dataController.getDataProvider();
    }

    protected abstract boolean isSelected(TItem var1);

    protected abstract void refreshValue();

    protected ComboBoxRenderManager<TItem> getRenderManager() {
        return this.renderManager;
    }

    protected ComboBoxDataController<TItem> getDataController() {
        return this.dataController;
    }

    protected ComboBoxDataCommunicator<TItem> getDataCommunicator() {
        return this.dataController != null ? this.dataController.getDataCommunicator() : null;
    }

    protected CompositeDataGenerator<TItem> getDataGenerator() {
        return this.dataController != null ? this.dataController.getDataGenerator() : null;
    }

    protected DataKeyMapper<TItem> getKeyMapper() {
        return this.getDataCommunicator() != null ? this.getDataCommunicator().getKeyMapper() : null;
    }

    @ClientCallable
    private void confirmUpdate(int id) {
        this.dataController.confirmUpdate(id);
    }

    @ClientCallable
    private void setViewportRange(int start, int length, String filter) {
        this.dataController.setViewportRange(start, length, filter);
    }

    @ClientCallable
    private void resetDataCommunicator() {
        this.dataController.resetDataCommunicator();
    }

    protected void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    private void initConnector() {
        this.getElement().executeJs("window.Vaadin.Flow.comboBoxConnector.initLazy(this)", new Object[0]);
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    public Validator<TValue> getDefaultValidator() {
        return this.defaultValidator;
    }

    protected void validate() {
        this.validationController.validate(this.getValue());
    }

    protected ComboBoxBaseI18n getI18n() {
        return this.i18n;
    }

    protected void setI18n(ComboBoxBaseI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
    }

    private String getI18nErrorMessage(Function<ComboBoxBaseI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }

    private class CustomValueRegistration
    implements Registration {
        private Registration delegate;

        private CustomValueRegistration(Registration delegate) {
            this.delegate = delegate;
        }

        public void remove() {
            if (this.delegate != null) {
                this.delegate.remove();
                --ComboBoxBase.this.customValueListenersCount;
                if (ComboBoxBase.this.customValueListenersCount == 0) {
                    ComboBoxBase.this.setAllowCustomValue(false);
                }
                this.delegate = null;
            }
        }
    }

    @DomEvent(value="custom-value-set")
    public static class CustomValueSetEvent<TComponent extends ComboBoxBase<TComponent, ?, ?>>
    extends ComponentEvent<TComponent> {
        private final String detail;

        public CustomValueSetEvent(TComponent source, boolean fromClient, @EventData(value="event.detail") String detail) {
            super(source, fromClient);
            this.detail = detail;
        }

        public String getDetail() {
            return this.detail;
        }
    }

    public static interface SpringData
    extends Serializable {

        @FunctionalInterface
        public static interface CountCallback<PAGEABLE>
        extends Serializable {
            public long count(PAGEABLE var1, String var2);
        }

        @FunctionalInterface
        public static interface FetchCallback<PAGEABLE, T>
        extends Serializable {
            public List<T> fetch(PAGEABLE var1, String var2);
        }
    }
}

