/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox.dataview;

import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.Query;
import java.io.Serializable;
import java.util.stream.Stream;

final class ItemFetchHelper
implements Serializable {
    private ItemFetchHelper() {
    }

    static <T> Stream<T> getItems(DataCommunicator<T> dataCommunicator) {
        return dataCommunicator.getDataProvider().fetch(ItemFetchHelper.getQuery(dataCommunicator));
    }

    static <T> T getItem(DataCommunicator<T> dataCommunicator, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must be non-negative");
        }
        if (dataCommunicator.isDefinedSize()) {
            int itemCount = dataCommunicator.getDataProviderSize();
            if (itemCount == 0) {
                throw new IndexOutOfBoundsException(String.format("Requested index %d on empty data.", index));
            }
            if (index >= itemCount) {
                throw new IndexOutOfBoundsException(String.format("Given index %d should be less than the item count '%d'", index, itemCount));
            }
        }
        return dataCommunicator.getDataProvider().fetch(ItemFetchHelper.getQuery(dataCommunicator, index, 1)).findFirst().orElse(null);
    }

    static <T> Query getQuery(DataCommunicator<T> dataCommunicator) {
        return ItemFetchHelper.getQuery(dataCommunicator, 0, Integer.MAX_VALUE);
    }

    static <T> Query getQuery(DataCommunicator<T> dataCommunicator, int offset, int limit) {
        return dataCommunicator.buildQuery(offset, limit);
    }
}

