/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.vaadin.flow.component.combobox.ComboBoxBase;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateNode;
import java.util.HashSet;
import java.util.Set;

public class ComboBoxDataCommunicator<TItem>
extends DataCommunicator<TItem> {
    public ComboBoxDataCommunicator(ComboBoxBase<?, TItem, ?> comboBox, DataGenerator<TItem> dataGenerator, ArrayUpdater arrayUpdater, SerializableConsumer<ArrayNode> dataUpdater, StateNode stateNode, boolean fetchEnabled) {
        super(dataGenerator, arrayUpdater, dataUpdater, stateNode, fetchEnabled);
        this.setKeyMapper((DataKeyMapper)new SelectionPreservingKeyMapper<TItem>(comboBox));
    }

    public void notifySelectionChanged() {
        ((SelectionPreservingKeyMapper)this.getKeyMapper()).purgeItems();
    }

    protected static class SelectionPreservingKeyMapper<TItem>
    extends KeyMapper<TItem> {
        private final ComboBoxBase<?, TItem, ?> comboBox;
        private final Set<TItem> itemsMarkedForRemoval = new HashSet<TItem>();

        public SelectionPreservingKeyMapper(ComboBoxBase<?, TItem, ?> comboBox) {
            this.comboBox = comboBox;
        }

        public void remove(TItem item) {
            if (!this.comboBox.isSelected(item)) {
                super.remove(item);
            } else {
                this.itemsMarkedForRemoval.add(item);
            }
        }

        public String key(TItem item) {
            this.itemsMarkedForRemoval.remove(item);
            return super.key(item);
        }

        public void purgeItems() {
            HashSet<TItem> itemsToRemove = new HashSet<TItem>(this.itemsMarkedForRemoval);
            itemsToRemove.forEach(item -> {
                if (!this.comboBox.isSelected(item)) {
                    super.remove(item);
                    this.itemsMarkedForRemoval.remove(item);
                }
            });
        }
    }
}

