/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.renderers;

import java.util.Objects;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.TableCellElement;
import com.vaadin.client.widget.grid.RendererCellReference;

/**
 * Renderer that renders text into a cell.
 *
 * @since 7.4
 * @author Vaadin Ltd
 */
public class TextRenderer implements Renderer<String> {

    @Override
    public void render(RendererCellReference cell, String text) {
        TableCellElement element = cell.getElement();
        if (!Objects.equals(text, element.getInnerText())) {
            // optimization suggested by Oskar Hýbl, Cleverbee solutions
            setTextContent(element, text);
        }
    }

    private native void setTextContent(Element elem, String text)
    /*-{
        elem.textContent = text;
    }-*/;
}
