/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.connectors;

import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.user.client.ui.Widget;
import com.vaadin.shared.ui.AbstractSingleSelectState;

/**
 * An abstract class for single selection connectors.
 *
 * @author Vaadin Ltd
 * @since 8.0
 */
public abstract class AbstractSingleSelectConnector<WIDGET extends Widget & HasAllFocusHandlers>
        extends AbstractFocusableListingConnector<WIDGET> {

    @Override
    public AbstractSingleSelectState getState() {
        return (AbstractSingleSelectState) super.getState();
    }

    @Override
    public boolean isRequiredIndicatorVisible() {
        return getState().required && !isReadOnly();
    }
}
