/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.widgets;

import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.vaadin.client.Focusable;

/**
 * Focusable composite whose widget is {@link ChildFocusAwareFlowPanel} (flow
 * panel that tracks focus/blur events from its children).
 *
 * @author Vaadin Ltd
 * @since 8.0
 */
public abstract class FocusableFlowPanelComposite extends Composite
        implements HasAllFocusHandlers, Focusable {

    private final ChildFocusAwareFlowPanel panel;

    /**
     * Creates a new instance.
     */
    protected FocusableFlowPanelComposite() {
        panel = new ChildFocusAwareFlowPanel();
        initWidget(panel);
    }

    @Override
    protected final ChildFocusAwareFlowPanel getWidget() {
        return (ChildFocusAwareFlowPanel) super.getWidget();
    }

    @Override
    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return panel.addFocusHandler(handler);
    }

    @Override
    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return panel.addBlurHandler(handler);
    }

    @Override
    public void focus() {
        getWidget().focus();
    }
}
