/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.connectors.grid;

import java.util.Objects;

import com.google.gwt.dom.client.TableCellElement;
import com.vaadin.client.renderers.Renderer;
import com.vaadin.client.widget.grid.RendererCellReference;
import com.vaadin.shared.ui.Connect;
import com.vaadin.shared.ui.grid.renderers.HtmlRendererState;

/**
 * A connector for {@link UnsafeHtmlRenderer}.
 *
 * @since 8.0
 * @author Vaadin Ltd
 */
@Connect(com.vaadin.ui.renderers.HtmlRenderer.class)
public class UnsafeHtmlRendererConnector
        extends AbstractGridRendererConnector<String> {

    /**
     * Constructs a renderer for unsafe html content.
     */
    public static class UnsafeHtmlRenderer implements Renderer<String> {
        @Override
        public void render(RendererCellReference cell, String data) {
            TableCellElement element = cell.getElement();
            if (!Objects.equals(data, element.getInnerHTML())) {
                element.setInnerHTML(data);
            }
        }
    }

    @Override
    public UnsafeHtmlRenderer getRenderer() {
        return (UnsafeHtmlRenderer) super.getRenderer();
    }

    @Override
    public HtmlRendererState getState() {
        return (HtmlRendererState) super.getState();
    }
}
