/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui.datefield;

import com.vaadin.client.ui.VDateCalendarPanel;
import com.vaadin.client.ui.VPopupCalendar;
import com.vaadin.shared.ui.Connect;
import com.vaadin.shared.ui.datefield.DateResolution;
import com.vaadin.shared.ui.datefield.LocalDateFieldState;
import com.vaadin.ui.AbstractLocalDateField;

/**
 * A connector class for the abstract AbstractLocalDateField component.
 *
 * @author Vaadin Ltd
 *
 */
@Connect(AbstractLocalDateField.class)
public class DateFieldConnector
        extends TextualDateConnector<VDateCalendarPanel, DateResolution> {

    @Override
    protected boolean isResolutionMonthOrHigher() {
        return getWidget().getCurrentResolution()
                .compareTo(DateResolution.MONTH) >= 0;
    }

    @Override
    public VPopupCalendar getWidget() {
        return (VPopupCalendar) super.getWidget();
    }

    @Override
    public LocalDateFieldState getState() {
        return (LocalDateFieldState) super.getState();
    }
}
