/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui;

import com.vaadin.client.ui.textfield.AbstractTextFieldConnector;

/**
 * Implemented by all widgets used by a connector extending
 * {@link AbstractTextFieldConnector}.
 *
 * @since 8.0
 */
public interface AbstractTextFieldWidget {

    /**
     * Sets the selection range for the field.
     *
     * @param start
     *            the start of the selection
     * @param length
     *            the length of the selection
     */
    public void setSelectionRange(int start, int length);

    /**
     * Gets the current value of the field.
     *
     * @return the current text in the field
     */
    public String getValue();

    /**
     * Selects all text in the field.
     */
    public void selectAll();

    /**
     * Sets the read-only mode of the field.
     *
     * @param readOnly
     *            <code>true</code> to set the field to read-only,
     *            <code>false</code> otherwise
     */
    public void setReadOnly(boolean readOnly);

    /**
     * Gets the current cursor position inside the field.
     *
     * @return the current cursor position
     */
    public int getCursorPos();

}
