/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.widget.grid.events;

import com.google.gwt.event.shared.EventHandler;

/**
 * Handler for a Grid {@link GridSelectionAllowedEvent}, called when the Grid is
 * becomes allowed for selection or disallowed.
 *
 * @see GridSelectionAllowedEvent
 * @author Vaadin Ltd
 * @since 8.0
 *
 */
public interface GridSelectionAllowedHandler extends EventHandler {

    /**
     * Called when Grid selection is allowed value changes.
     *
     * @param event
     *            the {@link GridSelectionAllowedEvent} that was fired
     *
     */
    public void onSelectionAllowed(GridSelectionAllowedEvent event);
}
