/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.connectors.grid;

import com.vaadin.shared.ui.Connect;
import com.vaadin.shared.ui.grid.renderers.LocalDateRendererState;

/**
 * A connector for LocalDateRenderer.
 * <p>
 * The server-side Renderer operates on {@code LocalDate}s, but the data is
 * serialized as a string, and displayed as-is on the client side. This is to be
 * able to support the server's locale.
 *
 * @since 8.1
 * @author Vaadin Ltd
 */
@Connect(com.vaadin.ui.renderers.LocalDateRenderer.class)
public class LocalDateRendererConnector extends TextRendererConnector {

    @Override
    public LocalDateRendererState getState() {
        return (LocalDateRendererState) super.getState();
    }
}
