/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.widget.grid.events;

import com.google.gwt.event.shared.GwtEvent;

/**
 * A selection allowed event, fired by the Grid when its selection allowed value
 * changes.
 *
 * @since 8.0
 * @author Vaadin Ltd
 */
public class GridSelectionAllowedEvent
        extends GwtEvent<GridSelectionAllowedHandler> {
    /**
     * The type of this event.
     */
    public static final Type<GridSelectionAllowedHandler> TYPE = new Type<>();
    private final boolean isSelectionAllowed;

    /**
     * Creates a new event instance.
     *
     * @param selectionAllowed
     *            selection allowed value
     */
    public GridSelectionAllowedEvent(boolean selectionAllowed) {
        isSelectionAllowed = selectionAllowed;
    }

    @Override
    public Type<GridSelectionAllowedHandler> getAssociatedType() {
        return TYPE;
    }

    /**
     * Gets selection allowed value.
     *
     * @return {@code true} if selection is allowed, {@code false} otherwise
     */
    public boolean isSelectionAllowed() {
        return isSelectionAllowed;
    }

    @Override
    protected void dispatch(final GridSelectionAllowedHandler handler) {
        handler.onSelectionAllowed(this);
    }
}
