/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.client.ui.layout;

/**
 * Event listener for element resize events.
 *
 * @author Vaadin Ltd
 */
public interface ElementResizeListener {

    /**
     * Perform actions after element resize.
     *
     * @param event
     *            the element resize event
     */
    public void onElementResize(ElementResizeEvent event);
}
