/*
 * Vaadin Framework 7
 *
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.client;

public class StyleConstants {

    public static final String MARGIN_TOP = "margin-top";
    public static final String MARGIN_RIGHT = "margin-right";
    public static final String MARGIN_BOTTOM = "margin-bottom";
    public static final String MARGIN_LEFT = "margin-left";

    public static final String VERTICAL_SPACING = "vspacing";
    public static final String HORIZONTAL_SPACING = "hspacing";

    /**
     * Added to all UI components
     */
    public static final String UI_WIDGET = "v-widget";

    /**
     * Added to all layouts to denote they are layouts
     */
    public static final String UI_LAYOUT = "v-layout";

    public static final String MODIFIED = "v-modified";
    public static final String DISABLED = "v-disabled";

    public static final String REQUIRED = "v-required";

    public static final String REQUIRED_EXT = "-required";

    public static final String ERROR_EXT = "-error";

    /**
     * Style name and style name prefix for the error indicator element.
     * 
     * @since 7.7.11
     */
    public static final String STYLE_NAME_ERROR_INDICATOR = "v-errorindicator";
}
