/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.ui;

import com.vaadin.classic.v8.server.Helpers;
import com.vaadin.classic.v8.shared.ui.ContentMode;
import com.vaadin.classic.v8.ui.AbstractComponent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="div")
@CssImport(value="./label.css")
@JsModule(value="@vaadin/vaadin-lumo-styles/font-icons.js")
public class Label
extends AbstractComponent {
    private static final String V_CAPTION = "v-caption";
    private static final String V_CAPTIONTEXT = "v-captiontext";
    private static final String V_HAS_CAPTION = "v-has-caption";
    private static final String V_CAPTION_ON_TOP = "v-caption-on-top";
    private static long idCounter = 0L;
    private String caption;
    private Element vCaption;
    private Element vCaptionText;
    private final VLabel vLabel;
    private final String captionId;
    private boolean isCaptionAsHtml;
    private boolean isLabelUsingServerGeneratedId;

    @Override
    public void beforeClientResponse(boolean initial) {
        this.getElement().setAttribute("class", String.join((CharSequence)" ", this.getInternalStyles()));
        if (this.vCaption != null) {
            this.vCaption.setAttribute("class", this.createVCaptionClassNames());
        }
    }

    public Label() {
        this("");
    }

    public Label(String text) {
        this(text, ContentMode.TEXT);
    }

    public Label(String text, ContentMode contentMode) {
        this.getElement().getStyle().set("display", "contents");
        this.captionId = this.generateId();
        this.vLabel = new VLabel(text, contentMode);
        this.getElement().appendChild(new Element[]{this.vLabel.getElement()});
        if (Helpers.isVaadin7Defaults()) {
            this.setWidth(100.0f, Unit.PERCENTAGE);
        }
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public void setCaption(String caption) {
        if (Objects.equals(caption, this.caption)) {
            return;
        }
        this.caption = caption;
        if (this.caption == null) {
            this.removeCaption();
        } else {
            this.addCaption();
        }
        this.markAsDirty();
    }

    public ContentMode getContentMode() {
        return this.vLabel.getContentMode();
    }

    public void setContentMode(ContentMode contentMode) {
        this.vLabel.setContentMode(contentMode);
    }

    public void setValue(String value) {
        this.vLabel.setValue(value);
    }

    public String getValue() {
        return this.vLabel.getValue();
    }

    @Override
    public void setCaptionAsHtml(boolean captionAsHtml) {
        this.isCaptionAsHtml = captionAsHtml;
        this.updateVCaptionText();
    }

    @Override
    public boolean isCaptionAsHtml() {
        return this.isCaptionAsHtml;
    }

    public Stream<Component> getChildren() {
        return Stream.empty();
    }

    @Override
    public void setWidth(String width) {
        this.vLabel.setWidth(width);
    }

    @Override
    public void setWidth(float width, Unit unit) {
        this.vLabel.setWidth(width, unit);
    }

    @Override
    public float getWidth() {
        return this.vLabel.getWidth();
    }

    @Override
    public Unit getWidthUnits() {
        return this.vLabel.getWidthUnits();
    }

    @Override
    public void setHeight(String height) {
        this.vLabel.setHeight(height);
    }

    @Override
    public void setHeight(float height, Unit unit) {
        this.vLabel.setHeight(height, unit);
    }

    @Override
    public float getHeight() {
        return this.vLabel.getHeight();
    }

    @Override
    public Unit getHeightUnits() {
        return this.vLabel.getHeightUnits();
    }

    @Override
    public void setSizeFull() {
        this.vLabel.setSizeFull();
    }

    @Override
    public void setWidthFull() {
        this.vLabel.setWidthFull();
    }

    @Override
    public void setHeightFull() {
        this.vLabel.setHeightFull();
    }

    @Override
    public void setSizeUndefined() {
        this.vLabel.setSizeUndefined();
    }

    @Override
    public void setWidthUndefined() {
        this.vLabel.setWidthUndefined();
    }

    @Override
    public void setHeightUndefined() {
        this.vLabel.setHeightUndefined();
    }

    @Override
    public String getStyleName() {
        return this.vLabel.getStyleName();
    }

    @Override
    public void setStyleName(String style) {
        this.vLabel.setStyleName(style);
    }

    @Override
    public void setStyleName(String style, boolean add) {
        this.vLabel.setStyleName(style, add);
    }

    @Override
    public void addStyleName(String style) {
        this.vLabel.addStyleName(style);
    }

    @Override
    public void addStyleNames(String ... styles) {
        this.vLabel.addStyleNames(styles);
    }

    @Override
    public void removeStyleName(String style) {
        this.vLabel.removeStyleName(style);
    }

    @Override
    public void removeStyleNames(String ... styles) {
        this.vLabel.removeStyleNames(styles);
    }

    @Override
    public String getPrimaryStyleName() {
        return this.vLabel.getPrimaryStyleName();
    }

    @Override
    public void setPrimaryStyleName(String style) {
        this.vLabel.setPrimaryStyleName(style);
    }

    @Override
    protected Collection<String> getCustomStyles() {
        return this.vLabel.getCustomStyles();
    }

    @Override
    public boolean isEnabled() {
        return this.vLabel.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.markAsDirty();
        this.vLabel.setEnabled(enabled);
    }

    public void setId(String id) {
        if (this.isLabelUsingServerGeneratedId && "".equals(id)) {
            return;
        }
        this.vLabel.setId(id);
        this.isLabelUsingServerGeneratedId = false;
        this.setCaptionHtmlForAttribute();
    }

    public Optional<String> getId() {
        return this.vLabel.getId();
    }

    private String createVCaptionClassNames() {
        Stream<String> vCaptionClasses = Stream.concat(Stream.of(V_CAPTION, this.isEnabled() ? "" : "v-disabled"), this.getCustomStyles().stream().map(styleClass -> "v-caption-" + styleClass));
        return String.join((CharSequence)" ", vCaptionClasses.collect(Collectors.toSet()));
    }

    private void removeCaption() {
        this.getElement().getStyle().set("display", "contents");
        this.getElement().removeChild(new Element[]{this.vCaption});
        this.vCaption = null;
        this.vCaptionText = null;
        this.removeInternalStyles(V_HAS_CAPTION, V_CAPTION_ON_TOP);
        this.vLabel.removeAriaLabelledBy();
    }

    private void addCaption() {
        if (this.vCaption != null) {
            this.updateVCaptionText();
            return;
        }
        this.getElement().getStyle().remove("display");
        this.addCaptionElements();
        this.setCaptionHtmlForAttribute();
        this.addInternalStyles(V_HAS_CAPTION, V_CAPTION_ON_TOP);
        this.vLabel.setAriaLabelledBy(this.captionId);
    }

    private void updateVCaptionText() {
        String text;
        if (this.caption == null) {
            return;
        }
        String string = text = this.caption.isEmpty() ? "\u00a0" : this.caption;
        if (this.isCaptionAsHtml()) {
            this.vCaptionText.setProperty("innerHTML", text);
        } else {
            this.vCaptionText.setText(text);
        }
    }

    private void addCaptionElements() {
        if (this.vCaption != null) {
            return;
        }
        this.vCaptionText = ElementFactory.createSpan();
        this.vCaptionText.getClassList().add((Object)V_CAPTIONTEXT);
        this.updateVCaptionText();
        this.vCaption = ElementFactory.createDiv();
        this.vCaption.setAttribute("id", this.captionId);
        this.vCaption.appendChild(new Element[]{this.vCaptionText});
        this.getElement().insertChild(0, new Element[]{this.vCaption});
    }

    private void setCaptionHtmlForAttribute() {
        if (this.vCaption == null) {
            return;
        }
        if (!this.getId().isPresent()) {
            this.vLabel.setId(this.generateId());
            this.isLabelUsingServerGeneratedId = true;
        }
        this.vCaption.setAttribute("for", this.getId().get());
    }

    private String generateId() {
        return "lcp-label-" + ++idCounter;
    }

    @Tag(value="div")
    static class VLabel
    extends AbstractComponent {
        private static final String defaultPrimaryStyle = "v-label";
        private static final String V_LABEL_UNDEF_W = "v-label-undef-w";
        private ContentMode contentMode;
        private String value;

        @Override
        public void beforeClientResponse(boolean initial) {
            super.beforeClientResponse(initial);
            String primaryStyleName = this.getPrimaryStyleName();
            if (primaryStyleName != null && !defaultPrimaryStyle.equals(primaryStyleName)) {
                this.getElement().getClassList().set(primaryStyleName + "-undef-w", this.getWidth() == -1.0f);
            }
            this.getElement().getClassList().set(V_LABEL_UNDEF_W, this.getWidth() == -1.0f);
        }

        public VLabel(String text, ContentMode contentMode) {
            this.setPrimaryStyleName(defaultPrimaryStyle);
            this.value = text;
            this.contentMode = contentMode;
            this.updatePresentation();
        }

        public ContentMode getContentMode() {
            return this.contentMode;
        }

        public void setContentMode(ContentMode contentMode) {
            if (contentMode == this.contentMode) {
                return;
            }
            this.contentMode = contentMode;
            this.updatePresentation();
        }

        public void setValue(String value) {
            this.value = value == null ? "" : value;
            this.updatePresentation();
        }

        public String getValue() {
            return this.value;
        }

        public void removeAriaLabelledBy() {
            this.getElement().removeAttribute("aria-labelledby");
        }

        public void setAriaLabelledBy(String id) {
            this.getElement().setAttribute("aria-labelledby", id);
        }

        @Override
        protected void notifyParentAboutStyleChanges() {
            this.getParent().ifPresent(parent -> {
                ((Label)parent).markAsDirty();
                ((Label)parent).notifyParentAboutStyleChanges();
            });
        }

        private void updatePresentation() {
            switch (this.contentMode) {
                case TEXT: {
                    this.getElement().setText(this.value);
                    break;
                }
                case PREFORMATTED: {
                    this.getElement().removeAllChildren();
                    this.getElement().appendChild(new Element[]{ElementFactory.createPreformatted((String)this.value)});
                    break;
                }
                case HTML: {
                    this.getElement().setProperty("innerHTML", this.value);
                }
            }
        }
    }
}

