/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.ui;

import java.io.Serializable;

public class MarginInfo
implements Serializable {
    private static final int TOP = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 4;
    private static final int LEFT = 8;
    private static final int ALL = 15;
    private int bitMask;

    public MarginInfo(boolean enabled) {
        this.setMargins(enabled);
    }

    public MarginInfo(boolean top, boolean right, boolean bottom, boolean left) {
        this.doSetMargins(top, right, bottom, left);
    }

    public MarginInfo(boolean vertical, boolean horizontal) {
        this(vertical, horizontal, vertical, horizontal);
    }

    public MarginInfo(MarginInfo other) {
        this.setMargins(other);
    }

    @Deprecated
    MarginInfo(int bitMask) {
        this.bitMask = bitMask;
    }

    public void setMargins(boolean enabled) {
        this.bitMask = enabled ? 15 : 0;
    }

    public void setMargins(boolean top, boolean right, boolean bottom, boolean left) {
        this.doSetMargins(top, right, bottom, left);
    }

    public void setMargins(MarginInfo marginInfo) {
        this.bitMask = marginInfo.bitMask;
    }

    int getBitMask() {
        return this.bitMask;
    }

    public boolean hasAll() {
        return (this.bitMask & 0xF) == 15;
    }

    public boolean hasNone() {
        return (this.bitMask & 0xF) == 0;
    }

    public boolean hasLeft() {
        return (this.bitMask & 8) == 8;
    }

    public boolean hasRight() {
        return (this.bitMask & 2) == 2;
    }

    public boolean hasTop() {
        return (this.bitMask & 1) == 1;
    }

    public boolean hasBottom() {
        return (this.bitMask & 4) == 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MarginInfo)) {
            return false;
        }
        return ((MarginInfo)obj).bitMask == this.bitMask;
    }

    public int hashCode() {
        return this.bitMask;
    }

    public String toString() {
        return "MarginInfo(" + this.hasTop() + ", " + this.hasRight() + ", " + this.hasBottom() + ", " + this.hasLeft() + ")";
    }

    private void doSetMargins(boolean top, boolean right, boolean bottom, boolean left) {
        this.bitMask = top ? 1 : 0;
        this.bitMask += right ? 2 : 0;
        this.bitMask += bottom ? 4 : 0;
        this.bitMask += left ? 8 : 0;
    }
}

