/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.ui;

import com.vaadin.classic.v8.ui.Event;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Iterator;

public interface HasComponents
extends Iterable<Component> {
    @Override
    public Iterator<Component> iterator();

    public static class ComponentDetachEvent
    extends Event {
        private final Component component;

        public ComponentDetachEvent(Component container, Component detachedComponent) {
            super(container, false);
            this.component = detachedComponent;
        }

        public HasComponents getContainer() {
            return (HasComponents)this.getSource();
        }

        public Component getDetachedComponent() {
            return this.component;
        }
    }

    public static class ComponentAttachEvent
    extends Event {
        private final Component component;

        public ComponentAttachEvent(Component container, Component attachedComponent) {
            super(container, false);
            this.component = attachedComponent;
        }

        public HasComponents getContainer() {
            return (HasComponents)this.getSource();
        }

        public Component getAttachedComponent() {
            return this.component;
        }
    }

    @FunctionalInterface
    public static interface ComponentDetachListener
    extends ComponentEventListener<ComponentDetachEvent> {
        public void componentDetachedFromContainer(ComponentDetachEvent var1);

        default public void onComponentEvent(ComponentDetachEvent componentDetachEvent) {
            this.componentDetachedFromContainer(componentDetachEvent);
        }
    }

    @FunctionalInterface
    public static interface ComponentAttachListener
    extends ComponentEventListener<ComponentAttachEvent> {
        public void componentAttachedToContainer(ComponentAttachEvent var1);

        default public void onComponentEvent(ComponentAttachEvent componentAttachEvent) {
            this.componentAttachedToContainer(componentAttachEvent);
        }
    }

    public static interface ComponentAttachDetachNotifier
    extends Serializable {
        public Registration addComponentAttachListener(ComponentAttachListener var1);

        public Registration addComponentDetachListener(ComponentDetachListener var1);
    }
}

