/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.event;

import com.vaadin.classic.v8.event.MouseEvents;
import com.vaadin.classic.v8.ui.Label;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public interface LayoutEvents {

    public static class LayoutClickEvent
    extends MouseEvents.ClickEvent {
        private final Component clickedComponent;
        private final Component childComponent;

        public LayoutClickEvent(Component source, boolean fromClient, @EventData(value="event.clientX") int clientX, @EventData(value="event.clientY") int clientY, @EventData(value="event.detail") int clickCount, @EventData(value="event.button") int button, @EventData(value="event.ctrlKey") boolean ctrlKey, @EventData(value="event.shiftKey") boolean shiftKey, @EventData(value="event.altKey") boolean altKey, @EventData(value="event.metaKey") boolean metaKey, @EventData(value="event.clientX - element.getBoundingClientRect().x") int relativeX, @EventData(value="event.clientY - element.getBoundingClientRect().y") int relativeY, @EventData(value="event.target") Element eventTarget) {
            super(source, fromClient, clientX, clientY, clickCount, button, ctrlKey, shiftKey, altKey, metaKey, relativeX, relativeY);
            this.clickedComponent = LayoutClickEvent.getComponentForElement(eventTarget);
            this.childComponent = this.getSourcesDirectChildWith(this.clickedComponent).orElse(null);
        }

        private static Component getComponentForElement(Element eventTarget) {
            if (eventTarget == null) {
                return null;
            }
            Optional clickedComponent = ComponentUtil.findParentComponent((Element)eventTarget);
            if (clickedComponent.flatMap(Component::getParent).filter(parent -> parent instanceof Label).isPresent()) {
                clickedComponent = ((Component)clickedComponent.get()).getParent();
            }
            return clickedComponent.orElse(null);
        }

        private Optional<Component> getSourcesDirectChildWith(Component component) {
            if (component == this.source) {
                return Optional.empty();
            }
            Optional potentialDirectChild = Optional.of(component);
            while (potentialDirectChild.flatMap(Component::getParent).filter(that -> !Objects.equals(that, this.source)).isPresent()) {
                potentialDirectChild = potentialDirectChild.get().getParent();
            }
            return potentialDirectChild;
        }

        public Component getClickedComponent() {
            return this.clickedComponent;
        }

        public Component getChildComponent() {
            return this.childComponent;
        }
    }

    public static interface LayoutClickNotifier
    extends Serializable {
        public Registration addLayoutClickListener(LayoutClickListener var1);
    }

    @FunctionalInterface
    public static interface LayoutClickListener
    extends ComponentEventListener<LayoutClickEvent> {
        default public void onComponentEvent(LayoutClickEvent layoutClickEvent) {
            this.layoutClick(layoutClickEvent);
        }

        public void layoutClick(LayoutClickEvent var1);
    }
}

