/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.ui;

import com.vaadin.classic.v8.ui.AbstractComponent;
import com.vaadin.classic.v8.ui.AbstractSingleComponentContainer;
import com.vaadin.classic.v8.ui.ComponentContainer;
import com.vaadin.classic.v8.ui.HasComponents;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.shared.Registration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;

public abstract class AbstractComponentContainer
extends AbstractComponent
implements ComponentContainer {
    @Override
    public void addComponent(Component component) {
        if (component.getParent().isPresent()) {
            AbstractSingleComponentContainer.removeFromParent(component);
        }
        if (component instanceof AbstractComponent) {
            ((AbstractComponent)component).setParent(null);
        }
        ComponentContainer.super.add(new Component[]{component});
        this.fireComponentAttachEvent(component);
        this.markAsDirtyRecursive();
    }

    @Override
    public void addComponents(Component ... components) {
        for (Component component : components) {
            this.addComponent(component);
        }
    }

    public void add(Component ... components) {
        for (Component component : components) {
            this.addComponent(component);
        }
    }

    @Override
    public void moveComponentsFrom(ComponentContainer source) {
        ArrayList componentsToMove = new ArrayList(this.getComponentCount());
        source.iterator().forEachRemaining(componentsToMove::add);
        for (Component component : componentsToMove) {
            source.removeComponent(component);
        }
        this.addComponents(componentsToMove.toArray(new Component[0]));
    }

    @Override
    public void removeAllComponents() {
        this.removeAll();
    }

    public void removeAll() {
        this.getChildren().collect(Collectors.toList()).forEach(this::removeComponent);
    }

    @Override
    public void removeComponent(Component component) {
        if (this.equals(component.getParent().orElse(null))) {
            ComponentContainer.super.remove(new Component[]{component});
            this.fireComponentDetachEvent(component);
            this.markAsDirtyRecursive();
        }
    }

    public void remove(Component ... components) {
        for (Component component : components) {
            this.removeComponent(component);
        }
    }

    @Override
    public Iterator<Component> iterator() {
        return this.getChildren().iterator();
    }

    @Override
    public void setHeight(float height, Unit unit) {
        if (height != this.getHeight() || unit != this.getHeightUnits()) {
            super.setHeight(height, unit);
            this.markAsDirtyRecursive();
        }
    }

    @Override
    public void setWidth(float width, Unit unit) {
        if (width != this.getWidth() || unit != this.getWidthUnits()) {
            super.setWidth(width, unit);
            this.markAsDirtyRecursive();
        }
    }

    @Override
    public Registration addComponentAttachListener(HasComponents.ComponentAttachListener listener) {
        return this.getEventBus().addListener(HasComponents.ComponentAttachEvent.class, (ComponentEventListener)listener);
    }

    @Override
    public Registration addComponentDetachListener(HasComponents.ComponentDetachListener listener) {
        return this.getEventBus().addListener(HasComponents.ComponentDetachEvent.class, (ComponentEventListener)listener);
    }

    protected void fireComponentAttachEvent(Component component) {
        this.getEventBus().fireEvent((ComponentEvent)new HasComponents.ComponentAttachEvent((Component)this, component));
    }

    protected void fireComponentDetachEvent(Component component) {
        this.getEventBus().fireEvent((ComponentEvent)new HasComponents.ComponentDetachEvent((Component)this, component));
    }
}

