/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model.serializers;

import com.vaadin.flow.component.charts.model.DataProviderSeries;
import com.vaadin.flow.component.charts.model.PlotOptionsSeries;
import com.vaadin.flow.component.charts.model.serializers.BeanSerializationDelegate;
import com.vaadin.flow.component.charts.model.serializers.BeanSerializerDelegator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.ValueNode;

public class DataProviderSeriesBeanSerializer
extends BeanSerializationDelegate<DataProviderSeries> {
    public static final String xAttribute = "x";
    public static final String yAttribute = "y";

    @Override
    public Class<DataProviderSeries> getBeanClass() {
        return DataProviderSeries.class;
    }

    @Override
    public void serialize(DataProviderSeries bean, BeanSerializerDelegator<DataProviderSeries> serializer, JsonGenerator jgen, SerializationContext context) {
        jgen.writeStartObject();
        if (bean.getPlotOptions() != null && !(bean.getPlotOptions() instanceof PlotOptionsSeries)) {
            jgen.writePOJOProperty("type", (Object)bean.getPlotOptions().getChartType());
        }
        serializer.serializeProperties(bean, jgen, context);
        ArrayNode data = this.createDataArray(bean);
        jgen.writePOJOProperty("data", (Object)data);
        jgen.writeEndObject();
    }

    private ArrayNode createDataArray(DataProviderSeries<?> chartDataProvider) {
        ArrayNode data = JsonNodeFactory.instance.arrayNode();
        Set<String> attributes = chartDataProvider.getChartAttributes();
        this.checkRequiredProperties(attributes);
        Mode mode = this.inferSerializationMode(attributes);
        block6: for (Map<String, Optional<Object>> chartAttributeToValue : chartDataProvider.getValues()) {
            Optional<Object> xValue = chartAttributeToValue.getOrDefault(xAttribute, Optional.empty());
            Optional<Object> yValue = chartAttributeToValue.getOrDefault(yAttribute, Optional.empty());
            Optional<Object> oValue = chartAttributeToValue.getOrDefault("open", Optional.empty());
            Optional<Object> lValue = chartAttributeToValue.getOrDefault("low", Optional.empty());
            Optional<Object> hValue = chartAttributeToValue.getOrDefault("high", Optional.empty());
            Optional<Object> cValue = chartAttributeToValue.getOrDefault("close", Optional.empty());
            switch (mode.ordinal()) {
                case 0: {
                    Optional<Object> value = chartAttributeToValue.get(yAttribute);
                    this.addValue(data, value);
                    continue block6;
                }
                case 1: {
                    ArrayNode entryArray;
                    if (xValue.isPresent() && yValue.isPresent()) {
                        entryArray = JsonNodeFactory.instance.arrayNode();
                        data.add((JsonNode)entryArray);
                        this.addValue(entryArray, xValue);
                        this.addValue(entryArray, yValue);
                        continue block6;
                    }
                    data.addNull();
                    continue block6;
                }
                case 2: {
                    ArrayNode entryArray;
                    if (xValue.isPresent() && lValue.isPresent() && hValue.isPresent()) {
                        entryArray = JsonNodeFactory.instance.arrayNode();
                        data.add((JsonNode)entryArray);
                        this.addValue(entryArray, xValue);
                        this.addValue(entryArray, lValue);
                        this.addValue(entryArray, hValue);
                        continue block6;
                    }
                    data.addNull();
                    continue block6;
                }
                case 3: {
                    ArrayNode entryArray;
                    if (xValue.isPresent() && oValue.isPresent() && hValue.isPresent() && lValue.isPresent() && cValue.isPresent()) {
                        entryArray = JsonNodeFactory.instance.arrayNode();
                        data.add((JsonNode)entryArray);
                        this.addValue(entryArray, xValue);
                        this.addValue(entryArray, oValue);
                        this.addValue(entryArray, hValue);
                        this.addValue(entryArray, lValue);
                        this.addValue(entryArray, cValue);
                        continue block6;
                    }
                    data.addNull();
                    continue block6;
                }
            }
            ObjectNode entryObject = JsonNodeFactory.instance.objectNode();
            xValue.ifPresent(o -> this.addNamedValue(entryObject, xAttribute, xValue));
            yValue.ifPresent(o -> this.addNamedValue(entryObject, yAttribute, yValue));
            chartAttributeToValue.entrySet().stream().filter(e -> !((String)e.getKey()).equals(xAttribute)).filter(e -> !((String)e.getKey()).equals(yAttribute)).forEach(e -> this.addNamedValue(entryObject, (String)e.getKey(), (Optional)e.getValue()));
            data.add((JsonNode)entryObject);
        }
        return data;
    }

    private void checkRequiredProperties(Set<String> attributes) {
        Boolean hasYProperty = attributes.contains(yAttribute);
        Boolean hasHighProperty = attributes.contains("high");
        Boolean hasLowProperty = attributes.contains("low");
        if (!(hasYProperty.booleanValue() || hasHighProperty.booleanValue() && hasLowProperty.booleanValue())) {
            throw new IllegalStateException("ChartDataSeries' must have a property for 'y' values or for both high and low values. Check " + DataProviderSeries.class.getName() + " Javadoc");
        }
    }

    private Mode inferSerializationMode(Set<String> attributes) {
        switch (attributes.size()) {
            case 1: {
                if (attributes.contains(yAttribute)) {
                    return Mode.ONLY_Y;
                }
            }
            case 2: {
                if (attributes.contains(yAttribute) && attributes.contains(xAttribute)) {
                    return Mode.XY;
                }
            }
            case 3: {
                if (attributes.contains(xAttribute) && attributes.contains("low") && attributes.contains("high")) {
                    return Mode.XLH;
                }
            }
            case 5: {
                if (!attributes.contains(xAttribute) || !attributes.contains("open") || !attributes.contains("high") || !attributes.contains("low") || !attributes.contains("close")) break;
                return Mode.XOHLC;
            }
        }
        return Mode.OBJECT;
    }

    private void addValue(ArrayNode data, Optional<Object> value) {
        if (value.isPresent()) {
            ValueNode node = JsonNodeFactory.instance.pojoNode(value.get());
            data.add((JsonNode)node);
        }
    }

    private void addNamedValue(ObjectNode data, String name, Optional<Object> value) {
        if (value.isPresent()) {
            ValueNode node = JsonNodeFactory.instance.pojoNode(value.get());
            data.set(name, (JsonNode)node);
        }
    }

    private static enum Mode {
        ONLY_Y,
        XY,
        XLH,
        XOHLC,
        OBJECT;

    }
}

