/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.vaadin.flow.component.charts.model.AbstractConfigurationObject;
import com.vaadin.flow.component.charts.model.Completed;
import com.vaadin.flow.component.charts.model.GanttSeriesItemDependency;
import com.vaadin.flow.component.charts.model.style.Color;
import com.vaadin.flow.component.charts.util.Util;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class GanttSeriesItem
extends AbstractConfigurationObject {
    private Boolean collapsed;
    private Color color;
    private Number colorIndex;
    private Completed completed;
    private AbstractConfigurationObject custom;
    private List<GanttSeriesItemDependency> dependency;
    private String description;
    private Number end;
    private String id;
    private Number labelrank;
    private Boolean milestone;
    private String name;
    private String parent;
    private Number start;
    private Number y;

    public GanttSeriesItem() {
    }

    public GanttSeriesItem(String name, Instant start, Instant end) {
        this.setName(name);
        this.setStart(start);
        this.setEnd(end);
    }

    public GanttSeriesItem(Number y, Instant start, Instant end) {
        this.setY(y);
        this.setStart(start);
        this.setEnd(end);
    }

    public Number getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(Number colorIndex) {
        this.colorIndex = colorIndex;
    }

    public Boolean getCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(Boolean collapsed) {
        this.collapsed = collapsed;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Completed getCompleted() {
        return this.completed;
    }

    public void setCompleted(Completed completed) {
        this.completed = completed;
    }

    public void setCompleted(Number completed) {
        if (this.completed == null) {
            this.completed = new Completed();
        }
        this.completed.setAmount(completed);
    }

    public List<GanttSeriesItemDependency> getDependencies() {
        return this.dependency;
    }

    public void setDependencies(List<GanttSeriesItemDependency> dependencies) {
        this.dependency = dependencies;
    }

    public void addDependency(GanttSeriesItemDependency dependency) {
        if (this.dependency == null) {
            this.dependency = new ArrayList<GanttSeriesItemDependency>();
        }
        this.dependency.add(dependency);
    }

    public void addDependency(String to) {
        this.addDependency(new GanttSeriesItemDependency(to));
    }

    public Number getEnd() {
        return this.end;
    }

    public void setEnd(Instant end) {
        this.end = Util.toHighchartsTS(end);
    }

    public Boolean getMilestone() {
        return this.milestone;
    }

    public void setMilestone(Boolean milestone) {
        this.milestone = milestone;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public Number getStart() {
        return this.start;
    }

    public void setStart(Instant start) {
        this.start = Util.toHighchartsTS(start);
    }

    public Number getY() {
        return this.y;
    }

    public void setY(Number y) {
        this.y = y;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Number getLabelrank() {
        return this.labelrank;
    }

    public void setLabelrank(Number labelrank) {
        this.labelrank = labelrank;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractConfigurationObject getCustom() {
        return this.custom;
    }

    public void setCustom(AbstractConfigurationObject custom) {
        this.custom = custom;
    }
}

