/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.charts.model.AbstractConfigurationObject;
import com.vaadin.flow.component.charts.model.Lang;
import com.vaadin.flow.component.charts.model.style.Theme;
import com.vaadin.flow.component.charts.util.ChartSerialization;
import com.vaadin.flow.internal.JacksonUtils;
import java.io.Serializable;
import java.util.Objects;

public class ChartOptions
extends AbstractConfigurationObject {
    @JsonUnwrapped
    private Theme theme;
    private Lang lang;

    protected ChartOptions() {
    }

    private void updateOptions() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            return;
        }
        ObjectNode configurationNode = JacksonUtils.readTree((String)ChartSerialization.toJSON(this));
        ui.getElement().executeJs("customElements.get('vaadin-chart').__callHighchartsFunction('setOptions',$0,$1)", new Serializable[]{Boolean.valueOf(true), configurationNode});
    }

    public void setLang(Lang lang) {
        this.lang = lang;
        this.updateOptions();
    }

    public Lang getLang() {
        return this.lang;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        this.updateOptions();
    }

    public static ChartOptions get(UI ui) {
        Objects.requireNonNull(ui, "Given UI may not be null");
        ChartOptions options = (ChartOptions)ComponentUtil.getData((Component)ui, ChartOptions.class);
        if (options == null) {
            options = new ChartOptions();
            ComponentUtil.setData((Component)ui, ChartOptions.class, (Object)options);
        }
        return options;
    }

    public static ChartOptions get() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("This method must be used from UI thread");
        }
        return ChartOptions.get(ui);
    }
}

