/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.vaadin.flow.component.charts.model.AbstractConfigurationObject;
import com.vaadin.flow.component.charts.model.serializers.AxisListSerializer;
import com.vaadin.flow.component.charts.model.serializers.ChartEnumSerializer;
import com.vaadin.flow.component.charts.model.serializers.DateSerializer;
import com.vaadin.flow.component.charts.model.serializers.DefaultBeanSerializerModifier;
import com.vaadin.flow.component.charts.model.serializers.GradientColorStopsSerializer;
import com.vaadin.flow.component.charts.model.serializers.InstantSerializer;
import com.vaadin.flow.component.charts.model.serializers.PaneListSerializer;
import com.vaadin.flow.component.charts.model.serializers.SolidColorSerializer;
import com.vaadin.flow.component.charts.model.serializers.StopSerializer;
import com.vaadin.flow.component.charts.model.serializers.TimeUnitMultiplesSerializer;
import java.io.Serializable;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.ser.SerializerFactory;
import tools.jackson.databind.ser.ValueSerializerModifier;

public class ChartSerialization
implements Serializable {
    private static ObjectWriter jsonWriter = ChartSerialization.createObjectMapper().writer();

    private ChartSerialization() {
    }

    public static ObjectMapper createObjectMapper() {
        return ChartSerialization.createObjectMapper(new DefaultBeanSerializerModifier());
    }

    public static ObjectMapper createObjectMapper(ValueSerializerModifier modifier) {
        JsonMapper.Builder builder = (JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().changeDefaultPropertyInclusion(incl -> incl.withValueInclusion(JsonInclude.Include.NON_NULL))).changeDefaultVisibility(handler -> handler.withVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).withVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY))).addModule(ChartEnumSerializer.getModule())).addModule(StopSerializer.getModule())).addModule(TimeUnitMultiplesSerializer.getModule())).addModule(SolidColorSerializer.getModule())).addModule(GradientColorStopsSerializer.getModule())).addModule(AxisListSerializer.getModule())).addModule(PaneListSerializer.getModule())).addModule(DateSerializer.getModule())).addModule(InstantSerializer.getModule());
        SerializerFactory serializerFactory = builder.serializerFactory().withSerializerModifier(modifier);
        return ((JsonMapper.Builder)builder.serializerFactory(serializerFactory)).build();
    }

    public static void setObjectMapperInstance(ObjectWriter newObjectWriter) {
        jsonWriter = newObjectWriter;
    }

    public static String toJSON(AbstractConfigurationObject object) {
        try {
            return jsonWriter.writeValueAsString((Object)object);
        }
        catch (JacksonException e) {
            e.printStackTrace();
            throw new RuntimeException("Error while serializing " + object.getClass().getSimpleName(), e);
        }
    }
}

