/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vaadin.flow.component.charts.model.AbstractSeries;
import com.vaadin.flow.component.charts.model.DataSeriesItem;
import com.vaadin.flow.component.charts.model.Drilldown;
import com.vaadin.flow.component.charts.model.Series;
import com.vaadin.flow.component.charts.model.style.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataSeries
extends AbstractSeries {
    private List<DataSeriesItem> data = new ArrayList<DataSeriesItem>();
    @JsonIgnore
    private List<Series> drilldownSeries = new ArrayList<Series>();

    public DataSeries() {
    }

    public DataSeries(String[] categories, Number[] ys) {
        for (int i = 0; i < categories.length; ++i) {
            this.add(new DataSeriesItem(categories[i], ys[i]));
        }
    }

    public DataSeries(String name) {
        this.setName(name);
    }

    public DataSeries(List<DataSeriesItem> items) {
        this.setData(items);
    }

    public DataSeries(DataSeriesItem ... items) {
        this.setData(Arrays.asList(items));
    }

    public void addData(Number[][] entries) {
        for (Number[] entry : entries) {
            this.data.add(new DataSeriesItem(entry[0], entry[1]));
        }
    }

    public void setData(String[] categoryNames, Number[] values) {
        assert (categoryNames.length == values.length);
        this.data.clear();
        for (int i = 0; i < categoryNames.length; ++i) {
            this.data.add(new DataSeriesItem(categoryNames[i], values[i]));
        }
    }

    public void setData(String[] categoryNames, Number[] values, Color[] colors) {
        assert (categoryNames.length == values.length);
        assert (categoryNames.length == colors.length);
        this.data.clear();
        for (int i = 0; i < categoryNames.length; ++i) {
            DataSeriesItem item = new DataSeriesItem(categoryNames[i], values[i]);
            item.setColor(colors[i]);
            this.data.add(item);
        }
    }

    public void setData(Number ... values) {
        this.data.clear();
        for (int i = 0; i < values.length; ++i) {
            this.data.add(new DataSeriesItem(String.valueOf(values[i]), values[i]));
        }
    }

    public void setData(List<DataSeriesItem> data) {
        this.data = data;
    }

    public DataSeriesItem get(String name) {
        for (DataSeriesItem item : this.data) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public void add(DataSeriesItem item) {
        this.add(item, true, false);
    }

    public void addItemWithDrilldown(DataSeriesItem item, Series series) {
        this.add(item);
        if (series.getId() == null) {
            throw new IllegalArgumentException("Series ID may not be null");
        }
        item.setDrilldown(series.getId());
        this.addSeriesToDrilldownConfiguration(series);
    }

    public void addItemWithDrilldown(DataSeriesItem item) {
        this.add(item);
        item.setDrilldown(true);
    }

    private void addSeriesToDrilldownConfiguration(Series series) {
        if (this.getConfiguration() != null) {
            Drilldown drilldown = this.getConfiguration().getDrilldown();
            drilldown.addSeries(series);
        } else {
            this.drilldownSeries.add(series);
        }
    }

    boolean hasDrilldownSeries() {
        return !this.drilldownSeries.isEmpty();
    }

    List<Series> getDrilldownSeries() {
        return this.drilldownSeries;
    }

    public void add(DataSeriesItem item, boolean updateChartImmediately, boolean shift) {
        if (shift) {
            this.data.remove(0);
        }
        this.data.add(item);
        if (updateChartImmediately && this.getConfiguration() != null) {
            this.getConfiguration().fireDataAdded(this, item, shift);
        }
    }

    public void remove(DataSeriesItem item) {
        int index = this.data.indexOf(item);
        this.data.remove(index);
        if (this.getConfiguration() != null) {
            this.getConfiguration().fireDataRemoved(this, index);
        }
    }

    public List<DataSeriesItem> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public void update(DataSeriesItem item) {
        if (this.getConfiguration() != null) {
            this.getConfiguration().fireDataUpdated((Series)this, item, this.data.indexOf(item));
        }
    }

    public DataSeriesItem get(int index) {
        return this.data.get(index);
    }

    public int size() {
        return this.data.size();
    }

    public void clear() {
        this.data.clear();
    }

    public void setItemSliced(int index, boolean sliced) {
        this.setItemSliced(index, sliced, true, true);
    }

    public void setItemSliced(int index, boolean sliced, boolean redraw) {
        this.setItemSliced(index, sliced, redraw, true);
    }

    public void setItemSliced(int index, boolean sliced, boolean redraw, boolean animation) {
        DataSeriesItem item = this.get(index);
        item.setSliced(sliced);
        this.getConfiguration().fireItemSliced(this, index, sliced, redraw, animation);
    }
}

