/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.vaadin.flow.component.charts.model.AbstractPlotOptions;
import com.vaadin.flow.component.charts.model.ChartType;
import com.vaadin.flow.component.charts.model.DashStyle;
import com.vaadin.flow.component.charts.model.DataLabels;
import com.vaadin.flow.component.charts.model.Label;
import com.vaadin.flow.component.charts.model.Level;
import com.vaadin.flow.component.charts.model.States;
import com.vaadin.flow.component.charts.model.Tooltip;
import com.vaadin.flow.component.charts.model.style.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlotOptionsSankey
extends AbstractPlotOptions {
    private Boolean allowPointSelect;
    private Boolean animation;
    private Color borderColor;
    private Number borderRadius;
    private Number borderWidth;
    private Boolean centerInCategory;
    private String className;
    private Boolean clip;
    private Color color;
    private Boolean colorByPoint;
    private Number colorIndex;
    private List<Color> colors;
    private String cursor;
    private Number curveFactor;
    private DashStyle dashStyle;
    private DataLabels dataLabels;
    private String description;
    private Boolean enableMouseTracking;
    private Boolean getExtremesFromAll;
    private Boolean inactiveOtherPoints;
    private Label label;
    private List<Level> levels;
    private String linkedTo;
    private Number linkOpacity;
    private Number minLinkWidth;
    private Number nodePadding;
    private Number nodeWidth;
    private Number opacity;
    private Boolean selected;
    private Boolean showCheckbox;
    private Boolean showInLegend;
    private Boolean skipKeyboardNavigation;
    private States states;
    private Boolean stickyTracking;
    private Tooltip tooltip;
    private Number turboThreshold;
    private Boolean visible;

    public Boolean getAllowPointSelect() {
        return this.allowPointSelect;
    }

    public void setAllowPointSelect(Boolean allowPointSelect) {
        this.allowPointSelect = allowPointSelect;
    }

    public Boolean getAnimation() {
        return this.animation;
    }

    public void setAnimation(Boolean animation) {
        this.animation = animation;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Number getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(Number borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Boolean getCenterInCategory() {
        return this.centerInCategory;
    }

    public void setCenterInCategory(Boolean centerInCategory) {
        this.centerInCategory = centerInCategory;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Boolean getClip() {
        return this.clip;
    }

    public void setClip(Boolean clip) {
        this.clip = clip;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Boolean getColorByPoint() {
        return this.colorByPoint;
    }

    public void setColorByPoint(Boolean colorByPoint) {
        this.colorByPoint = colorByPoint;
    }

    public Number getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(Number colorIndex) {
        this.colorIndex = colorIndex;
    }

    public Color[] getColors() {
        return this.toArray(this.colors, Color[]::new);
    }

    public void setColors(Color ... colors) {
        this.colors = this.toList(colors);
    }

    public void addColor(Color color) {
        if (this.colors == null) {
            this.colors = new ArrayList<Color>();
        }
        this.colors.add(color);
    }

    public void removeColor(Color color) {
        this.safeRemove(this.colors, color);
    }

    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public Number getCurveFactor() {
        return this.curveFactor;
    }

    public void setCurveFactor(Number curveFactor) {
        this.curveFactor = curveFactor;
    }

    public DashStyle getDashStyle() {
        return this.dashStyle;
    }

    public void setDashStyle(DashStyle dashStyle) {
        this.dashStyle = dashStyle;
    }

    public DataLabels getDataLabels() {
        if (this.dataLabels == null) {
            this.dataLabels = new DataLabels();
        }
        return this.dataLabels;
    }

    public void setDataLabels(DataLabels dataLabels) {
        this.dataLabels = dataLabels;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getEnableMouseTracking() {
        return this.enableMouseTracking;
    }

    public void setEnableMouseTracking(Boolean enableMouseTracking) {
        this.enableMouseTracking = enableMouseTracking;
    }

    public Boolean getGetExtremesFromAll() {
        return this.getExtremesFromAll;
    }

    public void setGetExtremesFromAll(Boolean getExtremesFromAll) {
        this.getExtremesFromAll = getExtremesFromAll;
    }

    public Boolean getInactiveOtherPoints() {
        return this.inactiveOtherPoints;
    }

    public void setInactiveOtherPoints(Boolean inactiveOtherPoints) {
        this.inactiveOtherPoints = inactiveOtherPoints;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public Level[] getLevels() {
        return this.toArray(this.levels, Level[]::new);
    }

    public void setLevels(Level ... levels) {
        this.levels = this.toList(levels);
    }

    private <T> T[] toArray(List<T> list, IntFunction<T[]> generator) {
        return list != null ? list.stream().toArray(generator) : generator.apply(0);
    }

    private <T> List<T> toList(T ... items) {
        return Stream.of(items).collect(Collectors.toCollection(ArrayList::new));
    }

    public void addLevel(Level level) {
        if (this.levels == null) {
            this.levels = new ArrayList<Level>();
        }
        this.levels.add(level);
    }

    public void removeLevel(Level level) {
        this.safeRemove(this.levels, level);
    }

    private <T> void safeRemove(List<T> list, T item) {
        if (list != null) {
            list.remove(item);
        }
    }

    public String getLinkedTo() {
        return this.linkedTo;
    }

    public void setLinkedTo(String linkedTo) {
        this.linkedTo = linkedTo;
    }

    public Number getLinkOpacity() {
        return this.linkOpacity;
    }

    public void setLinkOpacity(Number linkOpacity) {
        this.linkOpacity = linkOpacity;
    }

    public Number getMinLinkWidth() {
        return this.minLinkWidth;
    }

    public void setMinLinkWidth(Number minLinkWidth) {
        this.minLinkWidth = minLinkWidth;
    }

    public Number getNodePadding() {
        return this.nodePadding;
    }

    public void setNodePadding(Number nodePadding) {
        this.nodePadding = nodePadding;
    }

    public Number getNodeWidth() {
        return this.nodeWidth;
    }

    public void setNodeWidth(Number nodeWidth) {
        this.nodeWidth = nodeWidth;
    }

    public Number getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Number opacity) {
        this.opacity = opacity;
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public Boolean getShowCheckbox() {
        return this.showCheckbox;
    }

    public void setShowCheckbox(Boolean showCheckbox) {
        this.showCheckbox = showCheckbox;
    }

    public Boolean getShowInLegend() {
        return this.showInLegend;
    }

    public void setShowInLegend(Boolean showInLegend) {
        this.showInLegend = showInLegend;
    }

    public Boolean getSkipKeyboardNavigation() {
        return this.skipKeyboardNavigation;
    }

    public void setSkipKeyboardNavigation(Boolean skipKeyboardNavigation) {
        this.skipKeyboardNavigation = skipKeyboardNavigation;
    }

    public States getStates() {
        return this.states;
    }

    public void setStates(States states) {
        this.states = states;
    }

    public Boolean getStickyTracking() {
        return this.stickyTracking;
    }

    public void setStickyTracking(Boolean stickyTracking) {
        this.stickyTracking = stickyTracking;
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
    }

    public Number getTurboThreshold() {
        return this.turboThreshold;
    }

    public void setTurboThreshold(Number turboThreshold) {
        this.turboThreshold = turboThreshold;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Override
    public ChartType getChartType() {
        return ChartType.SANKEY;
    }
}

