/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vaadin.flow.component.charts.events.internal.AxisRescaledEvent;
import com.vaadin.flow.component.charts.events.internal.ConfigurationChangeListener;
import com.vaadin.flow.component.charts.events.internal.DataAddedEvent;
import com.vaadin.flow.component.charts.events.internal.DataRemovedEvent;
import com.vaadin.flow.component.charts.events.internal.DataUpdatedEvent;
import com.vaadin.flow.component.charts.events.internal.ItemSlicedEvent;
import com.vaadin.flow.component.charts.events.internal.SeriesAddedEvent;
import com.vaadin.flow.component.charts.events.internal.SeriesChangedEvent;
import com.vaadin.flow.component.charts.events.internal.SeriesStateEvent;
import com.vaadin.flow.component.charts.model.AbstractConfigurationObject;
import com.vaadin.flow.component.charts.model.AbstractPlotOptions;
import com.vaadin.flow.component.charts.model.Accessibility;
import com.vaadin.flow.component.charts.model.AnnotationItem;
import com.vaadin.flow.component.charts.model.AnnotationItemLabel;
import com.vaadin.flow.component.charts.model.Axis;
import com.vaadin.flow.component.charts.model.AxisDimension;
import com.vaadin.flow.component.charts.model.AxisList;
import com.vaadin.flow.component.charts.model.ChartConfiguration;
import com.vaadin.flow.component.charts.model.ChartConnectors;
import com.vaadin.flow.component.charts.model.ChartModel;
import com.vaadin.flow.component.charts.model.ChartType;
import com.vaadin.flow.component.charts.model.ColorAxis;
import com.vaadin.flow.component.charts.model.Credits;
import com.vaadin.flow.component.charts.model.DataSeries;
import com.vaadin.flow.component.charts.model.DataSeriesItem;
import com.vaadin.flow.component.charts.model.Drilldown;
import com.vaadin.flow.component.charts.model.Exporting;
import com.vaadin.flow.component.charts.model.Legend;
import com.vaadin.flow.component.charts.model.ListSeries;
import com.vaadin.flow.component.charts.model.Loading;
import com.vaadin.flow.component.charts.model.Navigation;
import com.vaadin.flow.component.charts.model.Navigator;
import com.vaadin.flow.component.charts.model.NoData;
import com.vaadin.flow.component.charts.model.Pane;
import com.vaadin.flow.component.charts.model.PaneList;
import com.vaadin.flow.component.charts.model.PlotOptionsSeries;
import com.vaadin.flow.component.charts.model.RangeSelector;
import com.vaadin.flow.component.charts.model.Scrollbar;
import com.vaadin.flow.component.charts.model.Series;
import com.vaadin.flow.component.charts.model.Subtitle;
import com.vaadin.flow.component.charts.model.Time;
import com.vaadin.flow.component.charts.model.Title;
import com.vaadin.flow.component.charts.model.Tooltip;
import com.vaadin.flow.component.charts.model.XAxis;
import com.vaadin.flow.component.charts.model.YAxis;
import com.vaadin.flow.component.charts.model.ZAxis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Configuration
extends AbstractConfigurationObject
implements ChartConfiguration {
    private Accessibility accessibility;
    private ChartModel chart = new ChartModel();
    private Title title;
    private Subtitle subtitle;
    private AxisList<XAxis> xAxis;
    private AxisList<YAxis> yAxis;
    private AxisList<ZAxis> zAxis;
    private AxisList<ColorAxis> colorAxis;
    private Tooltip tooltip;
    private Legend legend;
    private Credits credits;
    private Map<String, AbstractPlotOptions> plotOptions = new HashMap<String, AbstractPlotOptions>();
    private List<Series> series = new ArrayList<Series>();
    private Drilldown drilldown;
    private PaneList pane;
    private Exporting exporting = new Exporting(false);
    private RangeSelector rangeSelector;
    private Scrollbar scrollbar;
    private Loading loading;
    private Navigation navigation;
    private NoData noData;
    private Navigator navigator;
    private Time time;
    private List<AnnotationItem> annotations;
    private ChartConnectors connectors;
    @JsonIgnore
    private final List<ConfigurationChangeListener> changeListeners = new ArrayList<ConfigurationChangeListener>();

    public Accessibility getAccessibility() {
        if (this.accessibility == null) {
            this.setAccessibility(new Accessibility());
        }
        return this.accessibility;
    }

    public void setAccessibility(Accessibility accessibility) {
        this.accessibility = accessibility;
    }

    public ChartModel getChart() {
        if (this.chart == null) {
            this.setChart(new ChartModel());
        }
        return this.chart;
    }

    public void setChart(ChartModel chart) {
        Objects.requireNonNull(chart, "Given ChartModel may not be null");
        this.chart = chart;
    }

    public List<Series> getSeries() {
        return Collections.unmodifiableList(this.series);
    }

    public void addSeries(Series series) {
        this.series.add(series);
        series.setConfiguration(this);
        this.addSeriesToDrilldownConfiguration(series);
        this.fireSeriesAdded(series);
    }

    public void setSeries(List<Series> series) {
        this.series = new ArrayList<Series>(series);
        for (Series s : series) {
            s.setConfiguration(this);
            this.addSeriesToDrilldownConfiguration(s);
        }
    }

    public void setSeries(Series ... series) {
        this.setSeries(Arrays.asList(series));
    }

    private void addSeriesToDrilldownConfiguration(Series series) {
        DataSeries dataSeries;
        if (series instanceof DataSeries && (dataSeries = (DataSeries)series).hasDrilldownSeries()) {
            Drilldown drilldown = this.getDrilldown();
            for (Series s : ((DataSeries)series).getDrilldownSeries()) {
                drilldown.addSeries(s);
                this.addSeriesToDrilldownConfiguration(s);
            }
        }
    }

    public Drilldown getDrilldown() {
        if (this.drilldown == null) {
            this.drilldown = new Drilldown();
            this.drilldown.setConfiguration(this);
        }
        return this.drilldown;
    }

    public Title getTitle() {
        if (this.title == null) {
            this.title = new Title();
        }
        return this.title;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public void setTitle(String text) {
        this.title = new Title(text);
    }

    public Subtitle getSubTitle() {
        if (this.subtitle == null) {
            this.subtitle = new Subtitle();
        }
        return this.subtitle;
    }

    public void setSubTitle(String text) {
        this.subtitle = new Subtitle(text);
    }

    public void setSubTitle(Subtitle subTitle) {
        this.subtitle = subTitle;
    }

    public XAxis getxAxis() {
        if (this.xAxis == null) {
            this.xAxis = new AxisList();
        }
        if (this.xAxis.getNumberOfAxes() == 0) {
            XAxis x = new XAxis();
            x.setConfiguration(this);
            this.xAxis.addAxis(x);
        }
        return this.xAxis.getAxis(0);
    }

    public int getNumberOfxAxes() {
        if (this.xAxis == null) {
            return 0;
        }
        return this.xAxis.getNumberOfAxes();
    }

    public XAxis getxAxis(int index) {
        if (index >= 0 && this.xAxis != null && this.getNumberOfxAxes() > index) {
            return this.xAxis.getAxis(index);
        }
        return null;
    }

    public void removexAxes() {
        this.xAxis = null;
    }

    public void addxAxis(XAxis axis) {
        if (this.xAxis == null) {
            this.xAxis = new AxisList();
        }
        if (axis.getConfiguration() == null) {
            axis.setConfiguration(this);
        }
        this.xAxis.addAxis(axis);
    }

    public YAxis getyAxis() {
        if (this.yAxis == null) {
            this.yAxis = new AxisList();
        }
        if (this.yAxis.getNumberOfAxes() == 0) {
            YAxis y = new YAxis();
            y.setConfiguration(this);
            this.yAxis.addAxis(y);
        }
        return this.yAxis.getAxis(0);
    }

    public int getNumberOfyAxes() {
        if (this.yAxis == null) {
            return 0;
        }
        return this.yAxis.getNumberOfAxes();
    }

    public YAxis getyAxis(int index) {
        if (index >= 0 && this.yAxis != null && this.getNumberOfyAxes() > index) {
            return this.yAxis.getAxis(index);
        }
        return null;
    }

    public void removeyAxes() {
        this.yAxis = null;
    }

    public void addyAxis(YAxis axis) {
        if (this.yAxis == null) {
            this.yAxis = new AxisList();
        }
        if (axis.getConfiguration() == null) {
            axis.setConfiguration(this);
        }
        this.yAxis.addAxis(axis);
    }

    public AxisList<YAxis> getyAxes() {
        if (this.yAxis != null) {
            return this.yAxis;
        }
        return null;
    }

    public ZAxis getzAxis() {
        if (this.zAxis == null) {
            this.zAxis = new AxisList();
        }
        if (this.zAxis.getNumberOfAxes() == 0) {
            ZAxis y = new ZAxis();
            y.setConfiguration(this);
            this.zAxis.addAxis(y);
        }
        return this.zAxis.getAxis(0);
    }

    public int getNumberOfzAxes() {
        if (this.zAxis == null) {
            return 0;
        }
        return this.zAxis.getNumberOfAxes();
    }

    public ZAxis getzAxis(int index) {
        if (index >= 0 && this.zAxis != null && this.getNumberOfzAxes() > index) {
            return this.zAxis.getAxis(index);
        }
        return null;
    }

    public void removezAxes() {
        this.zAxis = null;
    }

    public void addzAxis(ZAxis axis) {
        if (this.zAxis == null) {
            this.zAxis = new AxisList();
        }
        if (axis.getConfiguration() == null) {
            axis.setConfiguration(this);
        }
        this.zAxis.addAxis(axis);
    }

    public AxisList<ZAxis> getzAxes() {
        if (this.zAxis != null) {
            return this.zAxis;
        }
        return null;
    }

    public Tooltip getTooltip() {
        if (this.tooltip == null) {
            this.tooltip = new Tooltip();
        }
        return this.tooltip;
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
    }

    public Credits getCredits() {
        if (this.credits == null) {
            this.credits = new Credits();
        }
        return this.credits;
    }

    public void setCredits(Credits credits) {
        this.credits = credits;
    }

    public void disableCredits() {
        Credits disabled = new Credits();
        disabled.setEnabled(false);
        this.setCredits(disabled);
    }

    public Legend getLegend() {
        if (this.legend == null) {
            this.legend = new Legend();
        }
        return this.legend;
    }

    public void setLegend(Legend legend) {
        this.legend = legend;
    }

    public Collection<AbstractPlotOptions> getPlotOptions() {
        return this.plotOptions.values();
    }

    public AbstractPlotOptions getPlotOptions(ChartType type) {
        return this.plotOptions.get(type.toString());
    }

    public void setPlotOptions(AbstractPlotOptions ... plotOptions) {
        this.plotOptions.clear();
        for (AbstractPlotOptions po : plotOptions) {
            this.addPlotOptions(po);
        }
    }

    public void addPlotOptions(AbstractPlotOptions plotOptions) {
        if (plotOptions instanceof PlotOptionsSeries) {
            this.plotOptions.put("series", plotOptions);
        } else {
            this.plotOptions.put(plotOptions.getChartType().toString(), plotOptions);
        }
    }

    public void setExporting(Boolean exporting) {
        this.exporting.setEnabled(exporting);
    }

    public void setExporting(Exporting exporting) {
        this.exporting = exporting;
    }

    public Exporting getExporting() {
        return this.exporting;
    }

    public Boolean isExporting() {
        return this.exporting.getEnabled();
    }

    public Pane getPane() {
        if (this.pane == null) {
            this.pane = new PaneList();
        }
        if (this.pane.getNumberOfPanes() == 0) {
            this.pane.addPane(new Pane());
        }
        return this.pane.getPane(0);
    }

    public void addPane(Pane pane) {
        if (this.pane == null) {
            this.pane = new PaneList();
        }
        this.pane.addPane(pane);
    }

    public void setRangeSelector(RangeSelector rangeSelector) {
        this.rangeSelector = rangeSelector;
    }

    public RangeSelector getRangeSelector() {
        if (this.rangeSelector == null) {
            this.rangeSelector = new RangeSelector();
        }
        return this.rangeSelector;
    }

    public Scrollbar getScrollbar() {
        if (this.scrollbar == null) {
            this.scrollbar = new Scrollbar();
        }
        return this.scrollbar;
    }

    public void setScrollbar(Scrollbar scrollbar) {
        this.scrollbar = scrollbar;
    }

    public NoData getNoData() {
        if (this.noData == null) {
            this.noData = new NoData();
        }
        return this.noData;
    }

    public void setNoData(NoData noData) {
        this.noData = noData;
    }

    public Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new Navigation();
        }
        return this.navigation;
    }

    public void setNavigation(Navigation navigation) {
        this.navigation = navigation;
    }

    public Loading getLoading() {
        if (this.loading == null) {
            this.loading = new Loading();
        }
        return this.loading;
    }

    public void setLoading(Loading loading) {
        this.loading = loading;
    }

    public Navigator getNavigator() {
        if (this.navigator == null) {
            this.navigator = new Navigator();
        }
        return this.navigator;
    }

    public void setNavigator(Navigator navigator) {
        this.navigator = navigator;
    }

    public Time getTime() {
        if (this.time == null) {
            this.time = new Time();
        }
        return this.time;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    public void reverseListSeries() {
        ArrayList<Series> newSeries = new ArrayList<Series>();
        String[] newCategories = new String[this.series.size()];
        for (int j = 0; j < this.getxAxis().getCategories().length; ++j) {
            String name = this.getxAxis().getCategories()[j];
            ArrayList<Number> numbers = new ArrayList<Number>();
            for (int i = 0; i < this.series.size(); ++i) {
                if (!(this.series.get(i) instanceof ListSeries)) {
                    throw new IllegalStateException();
                }
                numbers.add(((ListSeries)this.series.get(i)).getData()[j]);
                newCategories[i] = this.series.get(i).getName();
            }
            newSeries.add(new ListSeries(name, numbers.toArray(new Number[1])));
        }
        this.series = newSeries;
        this.getxAxis().setCategories(newCategories);
    }

    void fireDataAdded(Series series, Number value) {
        DataAddedEvent dataAddedEvent = new DataAddedEvent(series, value);
        for (ConfigurationChangeListener listener : this.changeListeners) {
            listener.dataAdded(dataAddedEvent);
        }
    }

    void fireDataAdded(Series series, DataSeriesItem item, boolean shift) {
        DataAddedEvent dataAddedEvent = new DataAddedEvent(series, item, shift);
        for (ConfigurationChangeListener listener : this.changeListeners) {
            listener.dataAdded(dataAddedEvent);
        }
    }

    void fireDataRemoved(Series series, int index) {
        DataRemovedEvent dataRemovedEvent = new DataRemovedEvent(series, index);
        for (ConfigurationChangeListener listener : this.changeListeners) {
            listener.dataRemoved(dataRemovedEvent);
        }
    }

    void fireDataUpdated(Series series, Number value, int pointIndex) {
        DataUpdatedEvent dataUpdatedEvent = new DataUpdatedEvent(series, value, pointIndex);
        for (ConfigurationChangeListener listener : this.changeListeners) {
            listener.dataUpdated(dataUpdatedEvent);
        }
    }

    void fireDataUpdated(Series series, DataSeriesItem item, int pointIndex) {
        DataUpdatedEvent dataUpdatedEvent = new DataUpdatedEvent(series, item, pointIndex);
        for (ConfigurationChangeListener listener : this.changeListeners) {
            listener.dataUpdated(dataUpdatedEvent);
        }
    }

    void fireSeriesAdded(Series series) {
        SeriesAddedEvent seriesAddedEvent = new SeriesAddedEvent(series);
        for (ConfigurationChangeListener listener : this.changeListeners) {
            listener.seriesAdded(seriesAddedEvent);
        }
    }

    void fireSeriesChanged(Series series) {
        SeriesChangedEvent event = new SeriesChangedEvent(series);
        for (ConfigurationChangeListener listener : this.changeListeners) {
            listener.seriesChanged(event);
        }
    }

    void fireSeriesEnabled(Series series, boolean enabled) {
        SeriesStateEvent seriesEnablationEvent = new SeriesStateEvent(series, enabled);
        for (ConfigurationChangeListener listener : this.changeListeners) {
            listener.seriesStateChanged(seriesEnablationEvent);
        }
    }

    private AxisDimension getAxisDimension(Axis axis) {
        if (axis instanceof ColorAxis) {
            return AxisDimension.COLOR_AXIS;
        }
        if (axis instanceof XAxis) {
            return AxisDimension.X_AXIS;
        }
        if (axis instanceof YAxis) {
            return AxisDimension.Y_AXIS;
        }
        if (axis instanceof ZAxis) {
            return AxisDimension.Z_AXIS;
        }
        return null;
    }

    private int getAxisIndex(AxisDimension dimension, Axis axis) {
        switch (dimension) {
            case X_AXIS: {
                return this.xAxis.indexOf(axis);
            }
            case Y_AXIS: {
                return this.yAxis.indexOf(axis);
            }
            case Z_AXIS: {
                return this.zAxis.indexOf(axis);
            }
            case COLOR_AXIS: {
                return this.colorAxis.indexOf(axis);
            }
        }
        return -1;
    }

    @Override
    public void fireAxesRescaled(Axis axis, Number minimum, Number maximum, boolean redraw, boolean animate) {
        AxisDimension axisType = this.getAxisDimension(axis);
        if (axisType != null) {
            int axisIndex = this.getAxisIndex(axisType, axis);
            AxisRescaledEvent event = new AxisRescaledEvent(axisType.getIndex(), axisIndex, minimum, maximum, redraw, animate);
            for (ConfigurationChangeListener listener : this.changeListeners) {
                listener.axisRescaled(event);
            }
        }
    }

    public void resetZoom() {
        this.resetZoom(true, true);
    }

    public void resetZoom(boolean redraw, boolean animate) {
        for (ConfigurationChangeListener listener : this.changeListeners) {
            listener.resetZoom(redraw, animate);
        }
    }

    void fireItemSliced(Series series, int index, boolean sliced, boolean redraw, boolean animation) {
        ItemSlicedEvent event = new ItemSlicedEvent(series, index, sliced, redraw, animation);
        for (ConfigurationChangeListener listener : this.changeListeners) {
            listener.itemSliced(event);
        }
    }

    public void addChangeListener(ConfigurationChangeListener listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    public void removeChangeListener(ConfigurationChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public ColorAxis getColorAxis() {
        if (this.colorAxis == null) {
            this.colorAxis = new AxisList();
        }
        if (this.colorAxis.getNumberOfAxes() == 0) {
            ColorAxis c = new ColorAxis();
            c.setConfiguration(this);
            this.colorAxis.addAxis(c);
        }
        return this.colorAxis.getAxis(0);
    }

    public int getNumberOfColorAxes() {
        if (this.colorAxis == null) {
            return 0;
        }
        return this.colorAxis.getNumberOfAxes();
    }

    public ColorAxis getColorAxis(int index) {
        if (index > 0 && this.colorAxis != null && this.getNumberOfColorAxes() > index) {
            return this.colorAxis.getAxis(index);
        }
        return null;
    }

    public void removeColorAxes() {
        this.colorAxis = null;
    }

    public void addColorAxis(ColorAxis axis) {
        if (this.colorAxis == null) {
            this.colorAxis = new AxisList();
        }
        if (axis.getConfiguration() == null) {
            axis.setConfiguration(this);
        }
        this.colorAxis.addAxis(axis);
    }

    public List<AnnotationItemLabel> getLabels() {
        return this.getLabelsAnnotation().getLabels();
    }

    public void setLabels(AnnotationItemLabel ... labels) {
        this.getLabelsAnnotation().setLabels(labels);
    }

    public void addLabel(AnnotationItemLabel label) {
        this.getLabels().add(label);
    }

    private AnnotationItem getLabelsAnnotation() {
        if (this.annotations == null) {
            this.annotations = List.of(new AnnotationItem());
        }
        return this.annotations.get(0);
    }

    public ChartConnectors getConnectors() {
        return this.connectors;
    }

    public void setConnectors(ChartConnectors connectors) {
        this.connectors = connectors;
    }
}

