/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vaadin.flow.component.charts.model.AbstractConfigurationObject;
import com.vaadin.flow.component.charts.model.AxisTitle;
import com.vaadin.flow.component.charts.model.AxisType;
import com.vaadin.flow.component.charts.model.ChartConfiguration;
import com.vaadin.flow.component.charts.model.Crosshair;
import com.vaadin.flow.component.charts.model.DateTimeLabelFormats;
import com.vaadin.flow.component.charts.model.Labels;
import com.vaadin.flow.component.charts.model.PlotBand;
import com.vaadin.flow.component.charts.model.PlotLine;
import com.vaadin.flow.component.charts.model.TickPosition;
import com.vaadin.flow.component.charts.model.TickmarkPlacement;
import com.vaadin.flow.component.charts.model.TimeUnitMultiples;
import com.vaadin.flow.component.charts.model.style.Color;
import com.vaadin.flow.component.charts.util.Util;
import java.time.Instant;
import java.util.Date;

public abstract class Axis
extends AbstractConfigurationObject {
    private static final long serialVersionUID = 1L;
    public static final String MINOR_TICK_INTERVAL_AUTO = "auto";
    protected Number min;
    protected Number max;
    private Integer axisIndex;
    @JsonIgnore
    private ChartConfiguration configuration;

    public void setAxisIndex(int i) {
        this.axisIndex = i;
    }

    protected Integer getAxisIndex() {
        return this.axisIndex;
    }

    public Number getMin() {
        return this.min;
    }

    public void setMin(Number min) {
        this.min = min;
    }

    public void setMin(Instant min) {
        this.min = Util.toHighchartsTS(min);
    }

    public Number getMax() {
        return this.max;
    }

    public void setMax(Number max) {
        this.max = max;
    }

    public void setMax(Instant max) {
        this.max = Util.toHighchartsTS(max);
    }

    public void setExtremes(Number min, Number max) {
        this.setExtremes(min, max, true, true);
    }

    public void setExtremes(Instant min, Instant max) {
        this.setExtremes(min, max, true, true);
    }

    @Deprecated(since="25.0", forRemoval=true)
    public void setExtremes(Date min, Date max) {
        this.setExtremes(min, max, true, true);
    }

    public void setExtremes(Number min, Number max, boolean redraw) {
        this.setExtremes(min, max, redraw, true);
    }

    public void setExtremes(Instant min, Instant max, boolean redraw) {
        this.setExtremes(min, max, redraw, true);
    }

    @Deprecated(since="25.0", forRemoval=true)
    public void setExtremes(Date min, Date max, boolean redraw) {
        this.setExtremes(min, max, redraw, true);
    }

    public void setExtremes(Number minimum, Number maximum, boolean redraw, boolean animate) {
        this.min = minimum;
        this.max = maximum;
        if (this.configuration != null) {
            this.configuration.fireAxesRescaled(this, minimum, maximum, redraw, animate);
        }
    }

    public void setExtremes(Instant minimum, Instant maximum, boolean redraw, boolean animate) {
        this.setMin(minimum);
        this.setMax(maximum);
        if (this.configuration != null) {
            this.configuration.fireAxesRescaled(this, this.min, this.max, redraw, animate);
        }
    }

    @Deprecated(since="25.0", forRemoval=true)
    public void setExtremes(Date minimum, Date maximum, boolean redraw, boolean animate) {
        this.setMin(minimum.toInstant());
        this.setMax(maximum.toInstant());
        if (this.configuration != null) {
            this.configuration.fireAxesRescaled(this, this.min, this.max, redraw, animate);
        }
    }

    public ChartConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ChartConfiguration configuration) {
        this.configuration = configuration;
    }

    public abstract Boolean getAllowDecimals();

    public abstract void setAllowDecimals(Boolean var1);

    public abstract Color getAlternateGridColor();

    public abstract void setAlternateGridColor(Color var1);

    public abstract String[] getCategories();

    public abstract void setCategories(String ... var1);

    public abstract void addCategory(String var1);

    public abstract void removeCategory(String var1);

    public abstract Number getCeiling();

    public abstract void setCeiling(Number var1);

    public abstract String getClassName();

    public abstract void setClassName(String var1);

    public abstract Crosshair getCrosshair();

    public abstract void setCrosshair(Crosshair var1);

    public abstract DateTimeLabelFormats getDateTimeLabelFormats();

    public abstract void setDateTimeLabelFormats(DateTimeLabelFormats var1);

    public abstract String getDescription();

    public abstract void setDescription(String var1);

    public abstract Boolean getEndOnTick();

    public abstract void setEndOnTick(Boolean var1);

    public abstract Number getFloor();

    public abstract void setFloor(Number var1);

    public abstract Number getGridZIndex();

    public abstract void setGridZIndex(Number var1);

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract Labels getLabels();

    public abstract void setLabels(Labels var1);

    public abstract Color getLineColor();

    public abstract void setLineColor(Color var1);

    public abstract Number getLineWidth();

    public abstract void setLineWidth(Number var1);

    public abstract Number getLinkedTo();

    public abstract void setLinkedTo(Number var1);

    public abstract Number getMaxPadding();

    public abstract void setMaxPadding(Number var1);

    public abstract Number getMinPadding();

    public abstract void setMinPadding(Number var1);

    public abstract Number getMinRange();

    public abstract void setMinRange(Number var1);

    public abstract Number getMinTickInterval();

    public abstract void setMinTickInterval(Number var1);

    public abstract String getMinorTickInterval();

    public abstract void setMinorTickInterval(String var1);

    public abstract Number getMinorTickLength();

    public abstract void setMinorTickLength(Number var1);

    public abstract TickPosition getMinorTickPosition();

    public abstract void setMinorTickPosition(TickPosition var1);

    public abstract Number getOffset();

    public abstract void setOffset(Number var1);

    public abstract Boolean getOpposite();

    public abstract void setOpposite(Boolean var1);

    public abstract PlotBand[] getPlotBands();

    public abstract void setPlotBands(PlotBand ... var1);

    public abstract void addPlotBand(PlotBand var1);

    public abstract void removePlotBand(PlotBand var1);

    public abstract PlotLine[] getPlotLines();

    public abstract void setPlotLines(PlotLine ... var1);

    public abstract void addPlotLine(PlotLine var1);

    public abstract void removePlotLine(PlotLine var1);

    public abstract Boolean getReversed();

    public abstract void setReversed(Boolean var1);

    public abstract Boolean getShowEmpty();

    public abstract void setShowEmpty(Boolean var1);

    public abstract Boolean getShowFirstLabel();

    public abstract void setShowFirstLabel(Boolean var1);

    public abstract Boolean getShowLastLabel();

    public abstract void setShowLastLabel(Boolean var1);

    public abstract Number getSoftMax();

    public abstract void setSoftMax(Number var1);

    public abstract Number getSoftMin();

    public abstract void setSoftMin(Number var1);

    public abstract Number getStartOfWeek();

    public abstract void setStartOfWeek(Number var1);

    public abstract Boolean getStartOnTick();

    public abstract void setStartOnTick(Boolean var1);

    public abstract Number getTickAmount();

    public abstract void setTickAmount(Number var1);

    public abstract Color getTickColor();

    public abstract void setTickColor(Color var1);

    public abstract Number getTickInterval();

    public abstract void setTickInterval(Number var1);

    public abstract Number getTickLength();

    public abstract void setTickLength(Number var1);

    public abstract Number getTickPixelInterval();

    public abstract void setTickPixelInterval(Number var1);

    public abstract TickPosition getTickPosition();

    public abstract void setTickPosition(TickPosition var1);

    public abstract Number[] getTickPositions();

    public abstract void setTickPositions(Number[] var1);

    public abstract TickmarkPlacement getTickmarkPlacement();

    public abstract void setTickmarkPlacement(TickmarkPlacement var1);

    public abstract AxisTitle getTitle();

    public abstract void setTitle(AxisTitle var1);

    public abstract AxisType getType();

    public abstract void setType(AxisType var1);

    public abstract Boolean getUniqueNames();

    public abstract void setUniqueNames(Boolean var1);

    public abstract TimeUnitMultiples[] getUnits();

    public abstract void setUnits(TimeUnitMultiples ... var1);

    public abstract void addUnit(TimeUnitMultiples var1);

    public abstract void removeUnit(TimeUnitMultiples var1);

    public abstract Boolean getVisible();

    public abstract void setVisible(Boolean var1);

    public abstract void setTitle(String var1);
}

