/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.vaadin.flow.component.charts.model.DataSeries;
import com.vaadin.flow.component.charts.model.DataSeriesItem;

public class RangeSeries
extends DataSeries {
    public RangeSeries() {
    }

    public RangeSeries(String name) {
        this.setName(name);
    }

    public RangeSeries(Number[] ... values) {
        this.addRangeData(values);
    }

    private void addRangeData(Number[][] values) {
        if (values == null || values.length == 0) {
            return;
        }
        Number[] firstItem = values[0];
        if (firstItem.length == 2) {
            this.addLowHighPairs(values);
        } else if (firstItem.length == 3) {
            this.addTriples(values);
        } else {
            throw new IllegalArgumentException("Unregognized data format");
        }
    }

    private void addTriples(Number[][] values) {
        for (int i = 0; i < values.length; ++i) {
            Number[] numbers = values[i];
            this.add(new DataSeriesItem(numbers[0], numbers[1], numbers[2]));
        }
    }

    private void addLowHighPairs(Number[][] values) {
        for (int i = 0; i < values.length; ++i) {
            Number[] numbers = values[i];
            DataSeriesItem dataSeriesItem = new DataSeriesItem();
            dataSeriesItem.setLow(numbers[0]);
            dataSeriesItem.setHigh(numbers[1]);
            this.add(dataSeriesItem);
        }
    }

    public RangeSeries(String name, Number[] ... values) {
        this(name);
        this.addRangeData(values);
    }

    public void setRangeData(Number[] ... data) {
        this.clear();
        this.addRangeData(data);
    }
}

