/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vaadin.flow.component.charts.model.AbstractSeriesItem;
import com.vaadin.flow.component.charts.model.DataLabels;
import com.vaadin.flow.component.charts.model.Dial;
import com.vaadin.flow.component.charts.model.Marker;
import com.vaadin.flow.component.charts.model.style.Color;
import java.time.Instant;
import java.util.Date;

public class DataSeriesItem
extends AbstractSeriesItem {
    private Number low;
    private Number high;
    private Boolean selected;
    private Dial dial;
    private Object drilldown;
    private DataLabels dataLabels;
    private String cursor;
    private String description;
    @JsonIgnore
    private boolean customized = false;

    public DataSeriesItem() {
    }

    public DataSeriesItem(String name, Number y) {
        this.setName(name);
        this.setY(y);
        this.makeCustomized();
    }

    public DataSeriesItem(String name, Number y, Color color) {
        this.setName(name);
        this.setY(y);
        this.setColor(color);
        this.makeCustomized();
    }

    public DataSeriesItem(Number x, Number y) {
        this.setX(x);
        this.setY(y);
    }

    public DataSeriesItem(Number x, Number y, Color color) {
        this.setX(x);
        this.setY(y);
        this.setColor(color);
        this.makeCustomized();
    }

    public DataSeriesItem(Instant instant, Number y) {
        this.setX(instant);
        this.setY(y);
    }

    @Deprecated
    public DataSeriesItem(Date date, Number y) {
        this.setX(date);
        this.setY(y);
    }

    public DataSeriesItem(Instant instant, Number low, Number high) {
        this.setX(instant);
        this.setLow(low);
        this.setHigh(high);
    }

    @Deprecated
    public DataSeriesItem(Date date, Number low, Number high) {
        this.setX(date);
        this.setLow(low);
        this.setHigh(high);
    }

    public DataSeriesItem(Number x, Number low, Number high) {
        this.setX(x);
        this.setLow(low);
        this.setHigh(high);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.makeCustomized();
    }

    @Override
    public void setSliced(boolean sliced) {
        super.setSliced(sliced);
        this.makeCustomized();
    }

    public boolean isSelected() {
        return this.selected == null ? false : this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
        this.makeCustomized();
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        this.makeCustomized();
    }

    @Override
    public void setLegendIndex(Number legendIndex) {
        super.setLegendIndex(legendIndex);
        this.makeCustomized();
    }

    @Override
    public void setMarker(Marker marker) {
        super.setMarker(marker);
        this.makeCustomized();
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        this.makeCustomized();
    }

    public void setDial(Dial dial) {
        this.dial = dial;
        this.makeCustomized();
    }

    public Dial getDial() {
        return this.dial;
    }

    public boolean isCustomized() {
        return this.customized;
    }

    protected void makeCustomized() {
        this.customized = true;
    }

    public Number getLow() {
        return this.low;
    }

    public void setLow(Number low) {
        this.low = low;
    }

    public Number getHigh() {
        return this.high;
    }

    public void setHigh(Number high) {
        this.high = high;
    }

    void setDrilldown(String drilldown) {
        this.drilldown = drilldown;
    }

    void setDrilldown(Boolean drilldown) {
        this.drilldown = drilldown;
    }

    public DataLabels getDataLabels() {
        return this.dataLabels;
    }

    public void setDataLabels(DataLabels dataLabels) {
        this.dataLabels = dataLabels;
        this.makeCustomized();
    }

    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
        this.makeCustomized();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.makeCustomized();
    }
}

