/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.vaadin.flow.component.charts.model.AbstractSeries;
import com.vaadin.flow.component.charts.model.DataSeriesItem;
import com.vaadin.flow.component.charts.model.Series;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ListSeries
extends AbstractSeries {
    private List<Number> data = new ArrayList<Number>();

    public ListSeries() {
    }

    public ListSeries(String name) {
        super(name);
    }

    public ListSeries(Number ... values) {
        Collections.addAll(this.data, values);
    }

    public ListSeries(Collection<Number> values) {
        this.data.addAll(values);
    }

    public ListSeries(String name, Number ... values) {
        this(name);
        this.setData(values);
    }

    public ListSeries(String name, Collection<Number> values) {
        this(name);
        this.data.addAll(values);
    }

    public Number[] getData() {
        return this.data.toArray(new Number[this.data.size()]);
    }

    public void setData(Number ... values) {
        this.data.clear();
        Collections.addAll(this.data, values);
    }

    public void setData(List<Number> data) {
        this.data = data;
    }

    public void addData(Number number) {
        this.addData(number, true, false);
    }

    public void addData(Number number, boolean updateChartImmediately, boolean shift) {
        if (shift) {
            this.data.remove(0);
        }
        this.data.add(number);
        if (updateChartImmediately && this.getConfiguration() != null) {
            this.getConfiguration().fireDataAdded(this, new DataSeriesItem(this.data.size() - 1, number), shift);
        }
    }

    public void updatePoint(int pointIndex, Number newValue) {
        this.data.remove(pointIndex);
        this.data.add(pointIndex, newValue);
        if (this.getConfiguration() != null) {
            this.getConfiguration().fireDataUpdated((Series)this, newValue, pointIndex);
        }
    }
}

