/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.export;

import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendToolsLocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

class NodeRunner {
    private final FrontendToolsLocator frontendToolsLocator;

    NodeRunner() {
        this(new FrontendToolsLocator());
    }

    NodeRunner(FrontendToolsLocator frontendToolsLocator) {
        this.frontendToolsLocator = frontendToolsLocator;
    }

    String findNodeExecutable() {
        String nodeExecutableName = FrontendUtils.isWindows() ? "node.exe" : "node";
        File nodeExecutableFile = this.frontendToolsLocator.tryLocateTool(nodeExecutableName).orElse(null);
        if (nodeExecutableFile != null) {
            return nodeExecutableFile.getAbsolutePath();
        }
        File vaadinHomeDirectory = FrontendUtils.getVaadinHomeDirectory();
        nodeExecutableFile = new File(vaadinHomeDirectory, FrontendUtils.isWindows() ? "node/node.exe" : "node/node");
        if (this.frontendToolsLocator.verifyTool(nodeExecutableFile)) {
            return nodeExecutableFile.getAbsolutePath();
        }
        throw new IllegalStateException(String.format("The SVG generator requires a Node.js installation, however none could be found. Searched for a global installation in PATH, and in the Vaadin home directory: %s", vaadinHomeDirectory.getAbsolutePath()));
    }

    int runJavascript(String script) throws InterruptedException, IOException {
        String nodeExecutable = this.findNodeExecutable();
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodeExecutable);
        command.add("-e");
        if (FrontendUtils.isWindows()) {
            command.add(script.replace("\"", "\\\""));
        } else {
            command.add(script);
        }
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.inheritIO();
        Process process = builder.start();
        return process.waitFor();
    }
}

