/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.export;

import com.vaadin.flow.component.charts.export.ExportOptions;
import com.vaadin.flow.component.charts.export.NodeRunner;
import com.vaadin.flow.component.charts.model.AbstractConfigurationObject;
import com.vaadin.flow.component.charts.model.Configuration;
import com.vaadin.flow.component.charts.util.ChartSerialization;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class SVGGenerator
implements AutoCloseable {
    private static final String INTERNAL_BUNDLE_PATH = "/META-INF/frontend/generated/jsdom-exporter-bundle.js";
    private static final String SCRIPT_TEMPLATE = "const exporter = require('%s');\nexporter({\nchartConfigurationFile: '%s',\noutFile: '%s',\nexportOptions: %s,\n})";
    private final Path tempDirPath = Files.createTempDirectory("svg-export", new FileAttribute[0]);
    private final Path bundleTempPath = this.tempDirPath.resolve("export-svg-bundle.js");

    public SVGGenerator() throws IOException {
        Files.copy(this.getClass().getResourceAsStream(INTERNAL_BUNDLE_PATH), this.bundleTempPath, new CopyOption[0]);
    }

    @Override
    public void close() throws IOException {
        Files.deleteIfExists(this.bundleTempPath);
        Files.deleteIfExists(this.tempDirPath);
    }

    public String generate(Configuration chartConfiguration) throws IOException, InterruptedException {
        return this.generate(chartConfiguration, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generate(Configuration chartConfiguration, ExportOptions exportOptions) throws IOException, InterruptedException {
        if (this.isClosed()) {
            throw new IllegalStateException("This generator is already closed.");
        }
        Configuration config = Objects.requireNonNull(chartConfiguration, "Chart configuration must not be null.");
        String jsonConfig = ChartSerialization.toJSON((AbstractConfigurationObject)config);
        String jsonExportOptions = ChartSerialization.toJSON((AbstractConfigurationObject)exportOptions);
        Path chartConfigFilePath = Files.createTempFile(this.tempDirPath, "config", ".json", new FileAttribute[0]);
        String chartConfigFileName = chartConfigFilePath.toFile().getName();
        Files.writeString(chartConfigFilePath, (CharSequence)jsonConfig, StandardCharsets.UTF_8, new OpenOption[0]);
        Path chartFilePath = Files.createTempFile(this.tempDirPath, "chart", ".svg", new FileAttribute[0]);
        String chartFileName = chartFilePath.toFile().getName();
        String script = String.format(SCRIPT_TEMPLATE, this.bundleTempPath.toFile().getAbsolutePath().replaceAll("\\\\", "/"), chartConfigFileName, chartFileName, jsonExportOptions);
        NodeRunner nodeRunner = new NodeRunner();
        nodeRunner.runJavascript(script);
        try {
            String string = new String(Files.readAllBytes(chartFilePath), StandardCharsets.UTF_8);
            return string;
        }
        finally {
            Files.delete(chartFilePath);
            Files.delete(chartConfigFilePath);
        }
    }

    public boolean isClosed() {
        return !this.tempDirPath.toFile().exists();
    }
}

